#include "flash.h"
#include "mem.h"

extern void _flash_prg_(long dir, unsigned short dato);
extern void _flash_blk_erase_(long dir);

const int sector_addr[]={0,0x4000,0x6000,0x8000,0x10000,0x20000,0x30000,0x40000,
			 0x50000,0x60000,0x70000,0x80000,0x90000,0xa0000,0xb0000,
			 0xc0000,0xd0000,0xe0000,0xf0000,0x100000};
const int sector_size[]={0x4000,0x2000,0x2000,0x8000,0x10000,0x10000,0x10000,
			 0x10000,0x10000,0x10000,0x10000,
			 0x10000,0x10000,0x10000,0x10000,
			 0x10000,0x10000,0x10000,0x10000,0 };
 
int test_flash_range(long dir)
{
	if (dir&1) return -1;   //error: direccin impar
#ifdef DV2MB
	if (dir>=0 && dir<0x100000) return 0; 	//Flash APP
#endif
	if (dir>=FLASH_FREE && dir<0x10d00000) return 0; //Flash OS, OS prot.
	return -1;		// No flash
}


int flash_prg_w(long dir,unsigned short dato)
{
	if (test_flash_range(dir)) return -1;
	_flash_prg_(dir,dato);
}

int flash_erase_block(long dir)
{
	if (test_flash_range(dir)) return -1;
	_flash_blk_erase_(dir);
}

int flash_prg_blk(void *dst, void *src, int nbytes)
{
	int nw,dd;
	unsigned short *ps,a;
	
	if (nbytes&1) nbytes++; 	//n par de bytes
	if ((int)src&1) return -1;	//error: direccin fuente impar
	nw=nbytes>>1;
	dd=(int)dst;
	if (test_flash_range(dd)) return -1;	//error: direccin destino
	ps=(unsigned short *)src;
	for (;nw;nw--) {
		a=*ps++;
		_flash_prg_(dd,a);
		dd+=2;
	}
	return 0;
}
