#include "common.h"
#include "file.h"
#include "lcd.h"
#include "event.h"
#include "klib.h"
#include "fifo.h"
#include "task.h"
#include "vt.h"
#include "lcd.h"
#include "mem.h"
#include "flash.h"
#include "lang.h"

extern file_header *pf_ini;
extern const int sector_addr[];
extern const int sector_size[];

int sector(int dir)
{
	int i,d=-1;
	if (dir>=0x10c00000 && dir<0x10d00000) d=dir-0x10c00000;
#ifdef DV2MB
	if (dir>=0 && dir<0x100000) d=dir;
#endif	
	if (d==-1) return d;
	for (i=0;i<19;i++) {
		if (d>=sector_addr[i] && d<sector_addr[i+1]) return i;
	}
	return -1;
}

unsigned short *pr;
unsigned short *pfin;
int fsbase;

int read_fs_init(int fs)
{
	if (fs==0) {
		pr=pfin=(unsigned short *)pf_ini;
		fsbase=0x10c00000;
		return 0;
	}
#ifdef DV2MB
	if (fs==1) {
		pr=pfin=(unsigned short *)0x4000;
		fsbase=0;
		return 0;
	}
#endif
	return -1;
}

int read_fs()
{
	file_header *pf;
	int sz;
	
	if (pr==pfin) {
	    pf=(file_header *)pfin;
	    for(;;) {
		if((int)pf-fsbase>=0x100000) return -1;
		if(pf->magic!=FILE_MAGIC) return -1;
		if(pf->type) break;
		sz=pf->size; if (sz&1) sz++;
		pf=(file_header *)((int)pf+sz+sizeof(file_header));
	    }
	    pr=(unsigned short *)pf;
	    sz=pf->size; if (sz&1) sz++;
	    pfin=(unsigned short *)((int)pr+sz+sizeof(file_header));
	}
	return *pr++;
}

file_header *find_first_del()
{
	int sz; 
	file_header *pf;
	pf=(file_header *)pfin;
	
	for (;;) {
		if((int)pf-fsbase>=0x100000) return (file_header *)0;
		if(pf->magic!=FILE_MAGIC) return (file_header *)0;
		if(pf->type==0) break;
		sz=pf->size; if (sz&1) sz++;
		pf=(file_header *)((int)pf+sz+sizeof(file_header));
	}
	return pf;
}

int sector_sucio(int sect)
{
	int i;
	unsigned short *ps;
	ps=(unsigned short *)(fsbase+sector_addr[sect]);
	for(i=sector_size[sect]>>1;i;i--) {
		if(*ps++ != 0xffff) return -1;
	}
	return 0;
}

void fs_defrag(int fs)
{
	int i,j,k,s0,s1,s2,dir,dato,end;
	unsigned short *buffer;
	file_header *pf;
	
	if (read_fs_init(fs)==-1) return;

	if ((buffer=(unsigned short *)kmalloc(S_RAM,0x10000))==(unsigned short *)0){
		kprintf(MSG_DEFRAG_NOMEM);
		return;
	}

	kprintf("\nFS%d:\n",fs);
	s0=sector((int)pfin);
	for (i=0;i<s0;i++) kputchar('#');
	
	pf=file_find_free(fs);
	if(!pf) s2=19; else s2=sector((int)pf);
	pf=find_first_del();
	if(!pf) s1=s2; else s1=sector((int)pf);
	
	for(;i<s1;i++) {
		j=sector_size[i]>>1;
		for(;j;j--) read_fs();
		kputchar('S');
	}

	for(end=0;i<19;i++) {
		if(end) break;
		j=sector_size[i]>>1;
		for (k=0;k<j;k++) {
			if((dato=read_fs())==-1) {end=1; break;}
			buffer[k]=dato&0xffff;
		}
		dir=sector_addr[i]+fsbase;
		j=k;
		if(j) {
		    flash_erase_block(dir);
		    for (k=0;k<j;k++) { flash_prg_w(dir,buffer[k]); dir+=2; }
		    kputchar('M');
		} else if(sector_sucio(i)) {
			  flash_erase_block(dir);
			  kputchar('D');
		       } else kputchar('S');	
	}
	
	for(;i<19;i++) {
		if(sector_sucio(i)) {
			dir=sector_addr[i]+fsbase;
			flash_erase_block(dir);
			kputchar('D');
		} else 	kputchar('S');
	}
	
	kfree((char *)buffer,0x10000);
	kprintf("\n");
}

int si_no(vt *);
int gettap(vt *);
extern TSS *cur_task;

void file_defrag()
{
	cls();
	gotoxy(0,9);kprintf(MSG_DEFRAG_Q);
	if(si_no(cur_task->vt)) {
		cls();kprintf(MSG_DEFRAG_DO);
		fs_defrag(0);
#ifdef DV2MB
		fs_defrag(1);
#endif
		kprintf(MSG_DEFRAG_DONE);
		gettap(cur_task->vt);
	}
}
