#include "common.h"
#include "klib.h"
#include "fifo.h"
#include "keyboard.h"
#include "event.h"
#include "file.h"
#include "file_action.h"
#include "task.h"
#include "vt.h"
#include "lcd.h"
#include "mem.h"
#include "lang.h"
#include "dct.h"

extern TSS *cur_task;

file_header *def_pf;

int gettap(vt *pvt);

/*-------------------------------------------------------------------------*/

void visor_grafico()
{
	vt *pvt;
	file_header *pf;
	int modo,ok,zip=0;

	pf=def_pf;
	if (!pf) task_exit();
	if (pf->type!=GRAPHIC) task_exit();
	switch(pf->subtype) {
	case SCREEN_DUMP_1BPP:  modo=0; ok=1; break;
	case SCREEN_DUMP_2BPP:  modo=1; ok=1; break;
	case SCREEN_DUMP_4BPP:  modo=2; ok=1; break;
        case WINDOW_ZIP: zip=1; modo=2; ok=1; break;
	default:        modo=0; ok=0; break;
	}
	pvt=open_vt(modo,1);
        cls();
	switch_vt(pvt);
	cursor_off(pvt);
	if (ok) {
           if (zip) dct_showimage (pvt->screen_base,(unsigned char *)((int)pf+sizeof(file_header)),0,0);
	   else memcpy(pvt->screen_base,(char *)((int)pf+sizeof(file_header)),pf->size);
	} else {
	   cls();
	   gotoxy(0,9); kprintf(MSG_FILE_ACTION_NOTSUP);
	}

	gettap(pvt);
	task_exit();
}

/*-------------------------------------------------------------------------*/

void text_reader()
{
	file_header *pf;
	vt *pvt;
	char *pini,*pfin,*pline,*p,a;
	int i,j,x,offx=0,maxx,key=0;

	pf=def_pf;
	if(!pf) task_exit();
	if(pf->type!=TEXT) task_exit();
	pini=(char *)((int)pf+sizeof(file_header));
	pfin=(char *)((int)pf+sizeof(file_header)+pf->size);
	pline=pini;

	pvt=open_vt(0,1);
	switch_vt(pvt);

	for(;;) {
		cls();
		cursor_off((vt *)0);
		p=pline;
		maxx=0;
		for(i=0;i<20;i++){
		    x=0;
		    for(;;) {
		    	if (p==pfin) break;
		    	a=*p++;
			if(a=='\n') break;
			if(a=='\r') continue;
			if(a==8) { if(x>0) x--; continue; }
			if(a=='\t') { x=(x+8)&0xfff8; continue; }
			if(x>=offx && x<offx+20) wrchar(x-offx,i,a);
			x++;
		    }
		    if(x>maxx) maxx=x;
		    if (p==pfin) break;
		}
		for(;;) {
			for(j=0;j<6;j++) {
			    i=fifo_getnb(pvt->event);
			    if (i!=-1) break;
			    task_sleep(1);
			}
			if (i==EV_LCD_TAP_PRESS) task_exit();
			if (i==EV_KEYBOARD_REL) key=0;
			if (i==EV_KEYBOARD) key=fifo_get(pvt->event);
			switch(key) {
			    case K_U:
			    	p=pline; p--;
			    	do p--; while(p>pini && *p!='\n');
			    	if (*p=='\n') p++;
			    	if (p>=pini) pline=p;
			    	break;
			    case K_D:
			    	p=pline;
			    	do p++; while(p<pfin && *p!='\n');
			    	if(*p=='\n') p++;
			    	if(p<pfin) pline=p;
			    	break;
			    case K_L:
			    	if(offx) offx--;
			    	break;
			    case K_R:
			    	if(offx+20<maxx) offx++;
			    	break;
			    case '\n':
			    	offx=0;
			    	break;
			    case 'b':
			    	offx=0;
			    	pline=pini;
			    	break;
			}
			if(key) break;
		}
	}
}

/*-------------------------------------------------------------------------*/

void file_take_action(file_header *pf)
{
	vt *pvt;
	
	pvt=cur_task->vt;
	if(!pvt) return;

	switch(pf->type) {
	case BINARY_CODE:
		if (pf->subtype==MC_PIC)
			task_start((void *)((int)pf+sizeof(file_header)),0x0000,
				   0x1000,16,pf->name);
			return;
	case TEXT:
		def_pf=pf;
		task_start(text_reader,0x2000,512,16,"TXTview");
		return;
	case GRAPHIC:
		def_pf=pf;
		task_start(visor_grafico,0x2000,512,16,"GRview");
		return;
	
	default:	return;
	}
}