
#define FILE_MAGIC 0xFA12AB34

typedef struct {
	unsigned int magic;
	unsigned int size;
	unsigned char type;
	unsigned char subtype;
	char name[16];
}file_header;


/* Tipos de ficheros */

enum {
	DELETED,	//0
	BINARY_DATA,	//BIN
	BINARY_CODE,	//EXE
	TEXT,		//TXT
	GRAPHIC,	//GR
	GRAPHIC_3D,	//3D
	AUDIO,		//SND
	MOVIE,		//MOV
	AGENDA,		//AG
	DATA_BASE,	//DB
	NFTYPES
};

/* Subtipos BINARY_CODE */

enum {
	DELETED_BINARY_CODE,
	MC_PIC,
	BYTECODE,
	TOKEM_BASIC
};

/* Subtipos TEXT */

enum {
	DELETED_TEXT,	
	ASCII_RAW,
	ASCII_ZIP,
	HYPERTEXT,
	PROGRAM_SOURCE_ASM,
	PROGRAM_SOURCE_C,
	PROGRAM_SOURCE_CPP,
	PROGRAM_SOURCE_JAVA,
	PROGRAM_SOURCE_BASIC,
	PROGRAM_SOURCE_FORTH
};

/* Suptipos GRAPHIC */

enum {
	DELETED_GRAPHIC,
	SCREEN_DUMP_1BPP,
	SCREEN_DUMP_2BPP,
	SCREEN_DUMP_4BPP,
	WINDOW,
	WINDOW_ZIP,
	VECTOR_TXT,
	VECTOR_BIN
};


//void file_init();
file_header *file_sel_ix(int tipo, int subt, int ix);
file_header *file_sel_next(int tipo, int subt, file_header *pf);
int file_get_nfiles(int tipo, int subt);
int file_get_free(int fs);
int file_get_del(int fs);
file_header *file_find_free(int fs);
int file_sel_int(int tipo, int subt, int ix);
file_header *file_creat(file_header *pf);
