#include "common.h"
#include "fifo.h"
#include "keyboard.h"
#include "event.h"
#include "mem.h"
#include "file.h"
#include "flash.h"
#include "lock.h"
#include "lang.h"

extern vt *cur_vt;
extern TSS *cur_task;

file_header *pf_ini=(file_header *)FLASH_FREE;

/*
void file_init()
{
	unsigned char *p;

	pf_ini=(file_header *)FLASH_FREE;
}
*/

int test_tipo(char tipo, char subt, char ftipo, char fsubt)
{
	if (tipo==0) return 0;
	if (subt==0) return 0;
	if (ftipo)
		if (tipo!=ftipo) return 0;
	if (fsubt)
		if (subt!=fsubt) return 0;
	return 1;
}

file_header *file_sel_ix(int tipo, int subt, int ix)
{
	file_header *pf;
	int i;

	// Buscamos en Flash OS
	pf=pf_ini;
	if (!pf) return (file_header *)0;

	for(i=0;;) {
		if((int)pf>0x10cfffff-sizeof(file_header)) break;
		if(pf->magic!=FILE_MAGIC) break;
		if(test_tipo(pf->type,pf->subtype,tipo,subt)) {
			if(i==ix) return pf;
			i++;
		}
		pf=(file_header *)((unsigned int)pf+pf->size+sizeof(file_header));
		if((int)pf&1) pf=(file_header *)((unsigned int)pf+1);
	}

#ifdef DV2MB
	// Buscamos en Flash APP
	pf=(file_header *)0x4000;

	for(;;) {
		if((int)pf>0xfffff-sizeof(file_header)) break;
		if(pf->magic!=FILE_MAGIC) break;
		if(test_tipo(pf->type,pf->subtype,tipo,subt)) {
			if(i==ix) return pf;
			i++;
		}
		pf=(file_header *)((unsigned int)pf+pf->size+sizeof(file_header));
		if((int)pf&1) pf=(file_header *)((unsigned int)pf+1);
	}
#endif
	return (file_header *)0;
}

file_header *file_sel_next(int tipo, int subt, file_header *pf)
{

    if(((int)pf>0 && (int)pf<0x100000) ||
       ((int)pf>0x10c20000 && (int)pf<0x10cffffc));
    else return (file_header *)0;
    if(pf->magic!=FILE_MAGIC) return (file_header *)0;
    if ((unsigned int)pf>=0x10c20000) {
	for(;;) {
		pf=(file_header *)((unsigned int)pf+pf->size+sizeof(file_header));
		if((int)pf&1) pf=(file_header *)((unsigned int)pf+1);
		if((int)pf>0x10cfffff-sizeof(file_header)) break;
		if(pf->magic!=FILE_MAGIC) break;
		if(test_tipo(pf->type,pf->subtype,tipo,subt)) return pf;
	}
#ifdef DV2MB
	pf=(file_header *)0x4000;
	if(pf->magic!=FILE_MAGIC) return (file_header *)0;
	if(test_tipo(pf->type,pf->subtype,tipo,subt)) return pf;
#endif
    }
#ifdef DV2MB
    // Buscamos en Flash APP

    if(pf->magic!=FILE_MAGIC) ;
    for(;;) {
	pf=(file_header *)((unsigned int)pf+pf->size+sizeof(file_header));
	if((int)pf&1) pf=(file_header *)((unsigned int)pf+1);
	if((int)pf>=0xfffff-sizeof(file_header)) break;
	if(pf->magic!=FILE_MAGIC) break;
	if(test_tipo(pf->type,pf->subtype,tipo,subt)) return pf;
    }
#endif
    return (file_header *)0;
}

int file_get_nfiles(int tipo, int subt)
{
	file_header *pf;
	int i;
	
	// Buscamos en Flash OS
	pf=pf_ini;
	if (!pf) return 0;
	
	for(i=0;;) {
		if((int)pf>0x10cfffff-sizeof(file_header)) break;
		if(pf->magic!=FILE_MAGIC) break;
		if(test_tipo(pf->type,pf->subtype,tipo,subt)) i++;
		pf=(file_header *)((unsigned int)pf+pf->size+sizeof(file_header));
		if((int)pf&1) pf=(file_header *)((unsigned int)pf+1);
	}

#ifdef DV2MB
	// Buscamos en Flash APP
	pf=(file_header *)0x4000;

	for(;;) {
		if((int)pf>0xfffff-sizeof(file_header)) break;
		if(pf->magic!=FILE_MAGIC) break;
		if(test_tipo(pf->type,pf->subtype,tipo,subt)) i++;
		pf=(file_header *)((unsigned int)pf+pf->size+sizeof(file_header));
		if((int)pf&1) pf=(file_header *)((unsigned int)pf+1);
	}
#endif

	return i;
}


int file_get_free(int fs)
{
	int fin;
	file_header *pf;

	switch (fs) {
	case 0:	pf=pf_ini; fin=0x10d00000;
		break;
#ifdef DV2MB
	case 1: pf=(file_header *)0x4000; fin=0x100000;
		break;
#endif
	default:	return 0;
	}


	for(;;) {
		if((int)pf>=fin-sizeof(file_header)) break;
		if(pf->magic!=FILE_MAGIC) break;
		pf=(file_header *)((unsigned int)pf+pf->size+sizeof(file_header));
		if((int)pf&1) pf=(file_header *)((unsigned int)pf+1);
	}
	return fin-(int)pf;
}

int file_get_del(int fs)
{
	int nd=0,fin;
	file_header *pf;

	switch (fs) {
	case 0:	pf=pf_ini; fin=0x10cfffff-sizeof(file_header);
		break;
#ifdef DV2MB
	case 1: pf=(file_header *)0x4000; fin=0xfffff-sizeof(file_header);
		break;
#endif
	default:	return 0;
	}

	for(;;) {
		if((int)pf>fin) break;
		if(pf->magic!=FILE_MAGIC) break;
		if (pf->type==0) {
			nd+=sizeof(file_header);
			nd+=pf->size;
			if(nd&1) nd++;
		}
		pf=(file_header *)((unsigned int)pf+pf->size+sizeof(file_header));
		if((int)pf&1) pf=(file_header *)((unsigned int)pf+1);
	}
	return nd;
}

file_header *file_find_free(int fs)
{
	int fin;
	file_header *pf;

	switch (fs) {
	case 0:	pf=pf_ini; fin=0x10cfffff-sizeof(file_header);
		break;
#ifdef DV2MB
	case 1: pf=(file_header *)0x4000; fin=0xfffff-sizeof(file_header);
		break;
#endif
	default:	return (file_header *)0;
	}

	for(;;) {
		if((int)pf>fin) return (file_header *)0;
		if(pf->magic!=FILE_MAGIC) return pf;
		pf=(file_header *)((unsigned int)pf+pf->size+sizeof(file_header));
		if((int)pf&1) pf=(file_header *)((unsigned int)pf+1);
	}
}

// Seleccin interactiva

const char *const file_type[]={"DEL","BIN","EXE","TXT","GR ","3D ","AU ","MOV","AG ","DB ",(char *)0};
const char *const long_file_type[]={LST_FILE_LTYPE};
const char *const bin_code_type[]={LST_FILE_CODE};
const char *const txt_type[]={LST_FILE_TXT};
const char *const gr_type[]={LST_FILE_GR};

int file_sel_int(int tipo, int subt, int ix)
{
	int nf,i,i0,i1,ev,j,k,x,y,ce,key=0;
	file_header *pf;
	vt *pvt;
	char *p;

	pvt=cur_task->vt;
	if(!pvt) return -1;
	
	nf=file_get_nfiles(tipo,subt);
	if(!nf) return -1;
	i0=0;
	if(nf>=14) {i0=ix-6; if(i0<0) i0=0;}
	for(;;) {
	    filled_rectangle(0,8,159,159,0);
	    hline(0,159,11,15);
	    hline(0,159,159-11-16,15);
	    hline(0,159,159-11,15);
	    gotoxy(0,2);
	    i1=i0+14; if(i1>nf) i1=nf;
	    for(i=i0;i<i1;i++) {
	    	if(i==i0) pf=file_sel_ix(tipo,subt,i);
	    	else pf=file_sel_next(tipo,subt,pf);
	    	if(!tipo) kprintf("%s ",file_type[pf->type]);
	    	kprintf("%s\n",pf->name);
	    }
	    if(ix>=i0 && ix<i1) {	// Seleccin en video inverso
	    	p=pvt->screen_base;
	    	j=(ix-i0+2)*8*20; k=j+8*20;
	    	j<<=pvt->video_mode; k<<=pvt->video_mode;
	    	for(;j<k;j++) p[j]^=0xff;
	    }
	    pf=file_sel_ix(tipo,subt,ix);
	    if (pf) {
	    	p="?";
	    	if(pf->type==BINARY_CODE) p=(char *)bin_code_type[pf->subtype];
	    	else if(pf->type==TEXT) p=(char *)txt_type[pf->subtype];
	    	else if(pf->type==GRAPHIC) p=(char *)gr_type[pf->subtype];
	    	gotoxy(0,17); kprintf("%s",p);
	    	gotoxy(16,17); kprintf("%dK",(pf->size+512)>>10);
	    }
	    gotoxy(0,19);
	    kprintf("<<   OK  %s  %s ",(i0)?"^^":"  ",(nf>i0+14)?"vv":"  ");
	    for(ce=0;!ce;){
		for(i=0;i<8;i++) {
			ev=fifo_getnb(pvt->event);
			if (ev!=-1) break;
			task_sleep(1);
		}
		switch(ev) {
		    case EV_LCD_TAP_REL:
		    case EV_KEYBOARD_REL:
		    	key=0;
		    	break;
		    case EV_KEYBOARD:
		    	key=fifo_get(pvt->event);
		    	break;
		    case EV_LCD_TAP_PRESS:
		    	x=fifo_get(pvt->event);
		    	y=fifo_get(pvt->event);
		    	if (y>160-11) {
		    	    x>>=5;
		    	    switch(x){
		    	    case 0:	return -1;
		    	    case 1:	return ix;
		    	    case 2:	key=K_U; break;
		    	    case 3:	key=K_D; break;
		    	    }
		    	} 
		    	y>>=3; y-=2;
		    	if(y>=0) if(i0+y<nf) {ix=i0+y; ce=1; }
		    	break;
		    
		}
		if (key) {
			if(key==K_U) { if (i0>0) i0--; ce=1;}
			if(key==K_D) { if (nf-i0>14) i0++; ce=1;}
		}
	    }
	}
}

file_header *file_creat(file_header *pfh)
{
	int i,n,fs;
	file_header *pf;
	static char busy=0;

	if (pfh->magic!=FILE_MAGIC) return (file_header *)0;

	lock(&busy);

	fs=0;
#ifdef DV2MB
	if (file_get_free(fs) < pfh->size) {
		fs=1;
		if (file_get_free(fs) < (pfh->size)) {
			unlock(&busy);
			return (file_header *)0;
		}
	}
#else
	if (file_get_free(fs) < pfh->size) {
		unlock(&busy);
		return (file_header *)0;
	}
#endif

	pf=file_find_free(fs);
	flash_prg_blk((void *)pf,(void *)pfh,sizeof(file_header));

	unlock(&busy);
	return pf;
}
