#include "common.h"
#include "task.h"
#include "fifo.h"


fifo ffevent; //La fifo de eventos del Sistema

void fifo_flush(fifo *ff)
{
	ff->pr=ff->pw=ff->buf;
	ff->blk_task=(TSS*)0;
}

short fifo_put(unsigned char data,fifo *ff)
{
	TSS *t;
	char *p=ff->pw;
	p++; if (p==&ff->buf[NFE]) p=ff->buf;
	if (p==ff->pr) return -1;	//fifo llena
	*ff->pw=data;
	ff->pw=p;
	if (ff->blk_task) {
		t=ff->blk_task;
		ff->blk_task=(TSS*)0;
		t->status=RUNNING;
	}
	return 0;
}

extern TSS *cur_task;

short fifo_get(fifo *ff)
{
	unsigned char data;
	
	while (ff->pw==ff->pr) {		//fifo vaca
		cur_task->status=SLEEPED;
		ff->blk_task=cur_task;
		asm volatile ("trap #1");	//schedule
	}
	data=*ff->pr;
	ff->pr++; if (ff->pr==&ff->buf[NFE]) ff->pr=ff->buf;

	return data;
}

short fifo_getnb(fifo *ff)
{
	unsigned char data;
	
	if (ff->pw==ff->pr) return -1;		//fifo vaca
	data=*ff->pr;
	ff->pr++; if (ff->pr==&ff->buf[NFE]) ff->pr=ff->buf;

	return data;
}
