#include "common.h"
#include "bit.h"
#include "task.h"
#include "fifo.h"
#include "event.h"
#include "lowio.h"
#include "klib.h"
#include "mem.h"
#include "pen.h"
#include "vt.h"
#include "keyboard.h"
#include "lcd.h"
#include "lang.h"

extern fifo ffevent;

extern const char *trap_name[];
extern TSS task_table[];
extern TSS *cur_task;
extern short ntask;
extern vt vt_table[];
extern long vt_alloc;
extern vt *cur_vt;
extern short vector_touch;

short calibrando=0;

void eventd()
{
	TSS *ts;
	vt *pvt;
	int i,j,vtix;
	unsigned short ev;
	short x,y;
	char off=0;

	pvt=open_vt(0,1);
	cls();
	*(unsigned char *)0xfffffb13=STOPWATCH;		//stopwatch
	kprintf(MSG_EVENTD_START);
	if (vector_touch) kprintf(MSG_EVENTD_VECTOR);

	for(;;){
    /* Eventos crudos */
		ev=fifo_get(&ffevent);
		if (ev>=0x80 && ev<0x8c) {
			kprintf("%s\n",trap_name[ev-0x80]);
			for (x=0;x<4;x++) {i<<=8;i|=fifo_get(&ffevent);}
			ts=(TSS*)i;
			kprintf("%s KILLED\n",ts->name);
			for (x=0;x<4;x++) { i<<=8; i|=fifo_get(&ffevent);}
			kprintf("PC =%08X\n",i);
			switch_vt(pvt);
		} else {
			if (ev==EV_GO_OFF) {
				kprintf("Stopwatch\n");
				off=1; pll_off();
			} else if (ev!=EV_DAY){
				*(unsigned char *)0xfffffb13=STOPWATCH;
				*(unsigned short *)0xfffffb0e|=1;  // Flag off
				*(unsigned short *)0xfffffb10|=1;  // IRQ on
			}
			switch(ev) {
                        case EV_DAY:
                                if (time_day()) kprintf("Ao nuevo\n");
                                if (off) pll_off();
                                break;
                        case EV_ALARM:
                                kprintf("ALARMA\n");
                                off=0;
                                break;
			case EV_ON_PRESS:
				for (i=128;i;i--) {
					task_sleep(1);
					if (fifo_getnb(&ffevent)==EV_ON_REL) {
						off^=1;
						if (off) pll_off();
						break;
					}
				}
				if (!i) *(char *)0xfffff409^=0x40;
				break;
			case EV_ON_REL:
				break;
			case EV_TAP_PRESS:
				if (!get_pen_xy(&x,&y)){
				  if (y<0) {
				    fifo_put(EV_FOCUS_OFF,cur_vt->event);
				    switch_vt(vt_table);
				    fifo_put(EV_FOCUS_ON,cur_vt->event);
				  } else if (y>=160) {
				    i=xy_to_key(x,y);
				    if (i>0) {
				      fifo_put(EV_KEYBOARD,cur_vt->event);
				      fifo_put(i,cur_vt->event);
				    }
				  } else {
				    fifo_put(EV_LCD_TAP_PRESS,cur_vt->event);
				    fifo_put(x,cur_vt->event);
				    fifo_put(y,cur_vt->event);
				  }
				}
				break;
			case EV_TAP_REL:
				if (calibrando) {
				  calibrando=0;
				  switch_vt(pvt);
				  pen_calibrate();
				} else if (y>=0 && y<160)
				  fifo_put(EV_LCD_TAP_REL,cur_vt->event);
				  else if (y>=160) fifo_put(EV_KEYBOARD_REL,cur_vt->event);
				break;
			case EV_TIME_PRESS: 
				break;
			case EV_UP_PRESS:
				fifo_put(EV_KEYBOARD,cur_vt->event);
				fifo_put(K_U,cur_vt->event);
				break;
			case EV_DOWN_PRESS:
				fifo_put(EV_KEYBOARD,cur_vt->event);
				fifo_put(K_D,cur_vt->event);
				break;
			case EV_LEFT_PRESS:
				//vtix=((int)cur_vt-(int)vt_table)/sizeof(vt);
				//do {
				//    vtix--;
				//    if (vtix<0) vtix=MAXVT-1;
				//} while (!bit_tst((char *)&vt_alloc,vtix));
				//switch_vt(&vt_table[vtix]);
				//fifo_put(EV_FOCUS_ON,cur_vt->event);
				fifo_put(EV_KEYBOARD,cur_vt->event);
				fifo_put(K_L,cur_vt->event);
				break;
			case EV_RIGHT_PRESS:
				fifo_put(EV_KEYBOARD,cur_vt->event);
				fifo_put(K_R,cur_vt->event);
				break;
			case EV_UP_REL:
			case EV_DOWN_REL:
			case EV_LEFT_REL:
			case EV_RIGHT_REL:
				fifo_put(EV_KEYBOARD_REL,cur_vt->event);
				break;
			case EV_FIND_PRESS:
				vtix=((int)cur_vt-(int)vt_table)/sizeof(vt);
				do {
				    vtix++;
				    if (vtix==MAXVT) vtix=0;
				} while (!bit_tst((char *)&vt_alloc,vtix));
				switch_vt(&vt_table[vtix]);
				fifo_put(EV_FOCUS_ON,cur_vt->event);
				break;
			}
		}
	}
}
