	.text

	.globl trapn	|x no implementado
	.globl ebus	|2 Error de bus
        .globl edir	|3 Error de direccin
        .globl eileg	|4 Cdigo ilegal
        .globl div0	|5 Divisin por 0
        .globl tchk	|6 CHK
	.globl ttrapv	|7 TRAPV
        .globl privi    |8 Instruccin privilegiada
        .globl traza    |9 Paso a Paso
        .globl emula    |a Emulador 1010
        .globl emulf    |b Emulador 1111 (copro)
        .globl sys_trap0	|20
        .globl sys_trap1	|21
        .globl l1_isr	|41
        .globl l2_isr	|42
        .globl l3_isr	|43
        .globl l4_isr	|44
        .globl l5_isr	|45
        .globl l6_isr_timer	|46
        .globl l7_isr	|47

|vector 2, Error de bus

ebus:	movm.l	%d0-%d7/%a0-%a6,-(%sp)
	move.l	%sp,-(%sp)
	move.l	#2,-(%sp)
	jsr	do_trap
	lea.l	8(%sp),%sp
	movm.l	(%sp)+,%d0-%d7/%a0-%a6
trapn:	rte

|vector 3, Error de direccin

edir:	movm.l	%d0-%d7/%a0-%a6,-(%sp)
	move.l	%sp,-(%sp)
	move.l	#3,-(%sp)
	jsr	do_trap
	lea.l	8(%sp),%sp
	movm.l	(%sp)+,%d0-%d7/%a0-%a6
	rte

|vector 4, Cdigo ilegal
eileg:	movm.l	%d0-%d7/%a0-%a6,-(%sp)
	move.l	%sp,-(%sp)
	move.l	#4,-(%sp)
	jsr	do_trap
	lea.l	8(%sp),%sp
	movm.l	(%sp)+,%d0-%d7/%a0-%a6
	rte

|5 Divisin por 0

div0:	movm.l	%d0-%d7/%a0-%a6,-(%sp)
	move.l	%sp,-(%sp)
	move.l	#5,-(%sp)
	jsr	do_trap
	lea.l	8(%sp),%sp
	movm.l	(%sp)+,%d0-%d7/%a0-%a6
	rte


|vector 6, CHK

tchk:	movm.l	%d0-%d7/%a0-%a6,-(%sp)
	move.l	%sp,-(%sp)
	move.l	#6,-(%sp)
	jsr	do_trap
	lea.l	8(%sp),%sp
	movm.l	(%sp)+,%d0-%d7/%a0-%a6
	rte


|vector 7, TRAPV
ttrapv:	movm.l	%d0-%d7/%a0-%a6,-(%sp)
	move.l	%sp,-(%sp)
	move.l	#7,-(%sp)
	jsr	do_trap
	lea.l	8(%sp),%sp
	movm.l	(%sp)+,%d0-%d7/%a0-%a6
	rte


|vector 8, Instruccin privilegiada
privi:	movm.l	%d0-%d7/%a0-%a6,-(%sp)
	move.l	%sp,-(%sp)
	move.l	#8,-(%sp)
	jsr	do_trap
	lea.l	8(%sp),%sp
	movm.l	(%sp)+,%d0-%d7/%a0-%a6
	rte


|vector 9, Ejecucin Paso a Paso
traza:	movm.l	%d0-%d7/%a0-%a6,-(%sp)
	move.l	%sp,-(%sp)
	move.l	#9,-(%sp)
	jsr	do_trap
	lea.l	8(%sp),%sp
	movm.l	(%sp)+,%d0-%d7/%a0-%a6
	rte


|vector 0xa, Emulador 1010
emula:	movm.l	%d0-%d7/%a0-%a6,-(%sp)
	move.l	%sp,-(%sp)
	move.l	#0xa,-(%sp)
	jsr	do_trap
	lea.l	8(%sp),%sp
	movm.l	(%sp)+,%d0-%d7/%a0-%a6
	rte


|vector 0xb, Emulador 1111 (copro)
emulf:	movm.l	%d0-%d7/%a0-%a6,-(%sp)
	move.l	%sp,-(%sp)
	move.l	#0xb,-(%sp)
	jsr	do_trap
	lea.l	8(%sp),%sp
	movm.l	(%sp)+,%d0-%d7/%a0-%a6
	rte

|------------------------------------------------------------------------
|				SYSCALLS
|------------------------------------------------------------------------
|TRAP #0: LLamadas al sistema
sys_trap0:
	movm.l %d1-%d7/%a0-%a6,-(%sp) |%d0 es la variable de retorno
	move.l %usp,%a0
	pea.l 4(%a0)		|Saltamos dir de retorno
	jsr ksyscall
	lea.l 4(%sp),%sp
	movm.l (%sp)+,%d1-%d7/%a0-%a6
	rte

|TRAP #1: conmutacin de tareas
sys_trap1:
	move.w	#0x2700,%sr
	movm.l	%d0-%d7/%a0-%a6,-(%sp)
	move.l	%usp,%a0
	move.l	%a0,-(%sp)

	move.l	cur_task,%a0
	move.l	%sp,(%a0)
	jsr	schedule	|retorna puntero a tarea
	move.l	%d0,cur_task
	move.l	%d0,%a0
	move.l	(%a0),%sp

	move.l	(%sp)+,%a0
	move.l	%a0,%usp
	movm.l	(%sp)+,%d0-%d7/%a0-%a6
	rte

|-------------------------------------------------------------------------
|				INTERRUPCIONES
|-------------------------------------------------------------------------
| Interrupt vectors
l1_isr:	rte
l2_isr:	rte

| Button interrupt
l3_isr:	movm.l	%d0-%d7/%a0-%a6,-(%sp)
	move.l	%usp,%a0
	move.l	%a0,-(%sp)
	jsr	level_3_irq
endirq:	tst.w	tic_lost
	beq	1f
	clr.w	tic_lost

	move.l	cur_task,%a0	|conmutacin de tareas
	move.l	%sp,(%a0)
	jsr	schedule	|retorna puntero a tarea
	move.l	%d0,cur_task
	move.l	%d0,%a0
	move.l	(%a0),%sp

1:	move.l	(%sp)+,%a0
	move.l	%a0,%usp
	movm.l	(%sp)+,%d0-%d7/%a0-%a6
	rte

| Multiple-source interrupt RTC,UART,SPI,PWM
l4_isr:	movm.l	%d0-%d7/%a0-%a6,-(%sp)
	move.l	%usp,%a0
	move.l	%a0,-(%sp)
	jsr	level_4_irq
	bra	endirq

| Touch panel interrupt
l5_isr:	movm.l	%d0-%d7/%a0-%a6,-(%sp)
	move.l	%usp,%a0
	move.l	%a0,-(%sp)
	jsr	level_5_irq
	bra	endirq

| Timer Interrupt
l6_isr_timer:	
	bclr.b	#0,0xfffff60b	| COMP=0
	move.w  #0x2500,%sr	| Habilitamos de nuevo IRQ de nivel 6

	movm.l	%d0-%d7/%a0-%a6,-(%sp)
	move.l	%usp,%a0
	move.l	%a0,-(%sp)

	move.w	#32384,%d0
	add.w	%d0,0xfffff604	| nuevo valor de compare
	
	jsr	level_6_irq

	move.w	#0x0700,%d0	| Si hemos interrumpido otra ISR
	and.w	64(%sp),%d0	| No conmutamos de tarea
	bne	1f

	move.l	cur_task,%a0
	move.l	%sp,(%a0)
	jsr	schedule	|retorna puntero a tarea
	move.l	%d0,cur_task
	move.l	%d0,%a0
	move.l	(%a0),%sp
	bra	2f
1:	move.w	#0xffff,tic_lost
2:	move.l	(%sp)+,%a0
	move.l	%a0,%usp

	movm.l	(%sp)+,%d0-%d7/%a0-%a6
	rte

l7_isr:	rte

	.data
tic_lost:	.word 0
