OUTPUT_FORMAT(srec)
OUTPUT_ARCH(m68k)
SEARCH_DIR(./)
__DYNAMIC  =  0;

/*********** MAPA DE MEMORIA ***********/

MEMORY
{
 user_ram : ORIGIN = 0x10000000, LENGTH = 128K
 super_ram : ORIGIN = 0x10000000+128K, LENGTH = 128K
 flash : ORIGIN = 0x10c10000, LENGTH = 1M
}


SECTIONS
{

/*********** RAM del USUARIO ***********/

  .user :
  {
    _buser = .;
  } >user_ram


/********* RAM del SUPERVISOR **********/

  .text :
  {
    _btext = .;
    *(.text)
    __CTOR_LIST__ = .;
    LONG((__CTOR_END__ - __CTOR_LIST__) / 4 - 2)
    *(.ctors)
    LONG(0)
    __CTOR_END__ = .;
    __DTOR_LIST__ = .;
    LONG((__DTOR_END__ - __DTOR_LIST__) / 4 - 2)
    *(.dtors)
    LONG(0)
    __DTOR_END__ = .;
    *(.lit)
    *(.shdata)
    *(.rodata)
    *(.rodata.str1.1)
    _etext = .;
  } > flash


  .data 0x10020000:
  AT ( ADDR(.text) + SIZEOF ( .text ) )
  {
    _data = .;
    *(.data)
    _edata = .;
  }

  .eh_fram SIZEOF(.data) + ADDR(.data) :
  AT ( ADDR(.text) + SIZEOF ( .text ) + SIZEOF ( .data ) )
   {
    *(.eh_fram)
    _eeh_fram = .;
   }

  .shbss SIZEOF(.eh_fram) + ADDR(.eh_fram) :
  {
    *(.shbss)
  } 

  .novol :
  {
    *(.novol)  
  }

  .bss :
  {
    __bss_start = ALIGN(0x8);
    *(.bss)
    *(COMMON)
    _end = ALIGN(0x80);
    __end = ALIGN(0x80);
  } 

/***************** ?????? ***************/

  .stab . (NOLOAD) :
  {
    [ .stab ]
  }
  .stabstr . (NOLOAD) :
  {
    [ .stabstr ]
  }

}
