#include "common.h"
#include "file.h"

#include "iidct.c"

typedef struct {
    unsigned char bitbuf;
    unsigned char *cmpbuf;
    unsigned short cbit;
    unsigned short nzeros;
} bitst;

extern inline int inbit(bitst *bs)
{
        int i;
        if (bs->cbit==0){
                bs->bitbuf=*bs->cmpbuf++;
                bs->cbit=8;
        }
        i=bs->bitbuf>>7;
        bs->bitbuf<<=1; bs->cbit--;
        return i;
}

int inbits(bitst *bs,int nb)
{
        int i=0;
        for (;nb;nb--) {
                i<<=1;
                if (inbit(bs)) i++;
        }
        return i;
}

int incoef(bitst *bs)
{
        int i,n;

        if (bs->nzeros) {
                bs->nzeros--;
                return 0;
        }
        n=inbit(bs);
        if (n==0) return n;
        n=inbits(bs,3);
        if(n!=0 && n!=4) {
                if (n<4) return n;
                return n-8;
        }
        if (n==4) {
                n=inbits(bs,6);
                if (n<4) {
                        bs->nzeros=48+8*n;
                        bs->nzeros--; return 0;
                }
                return -n;
        }
        n=inbits(bs,6);
        if (n<4) {
                bs->nzeros=16+8*n;
                bs->nzeros--; return 0;
        }
        return n;
}

void dct_showimage (unsigned char *panta, unsigned char *pfile,int ox,int oy)
{
	int i,is,js,j,k,n,nx,ny;
        short subf[64],subo[64];
        unsigned char *p;
        static const unsigned char swfr[64]={
        0,1,8,16,9,2,3,10,17,24,32,25,18,11,4,5,12,19,26,33,40,
        48,41,34,27,20,13,6,7,14,21,28,35,42,49,56,57,50,43,36,29,
        22,15,23,30,37,44,51,58,59,52,45,38,31,39,46,53,60,61,54,47,
        55,62,63};

        bitst bs;

        if (pfile[0]!='D' || pfile[1]!='C' || pfile[2]!='T' || pfile[3]!=1) {
                //printf("Bad file\n");
                //exit(0);
                return;
        }
        nx=pfile[4];     // n subimages X
        ny=pfile[5];     // n subimages Y

        bs.cmpbuf=&pfile[6]; bs.cbit=0; bs.nzeros=0;

        for (is=0;is<ny;is++) {
           for (js=0;js<nx;js++) {
                for (i=0;i<64;i++) {
                        subf[(js&1)?63-swfr[i]:swfr[i]]=incoef(&bs);
                }
                if (is<oy || is>oy+19) continue;
                if (js<ox || js>ox+19) continue;
                subf[53]+=1; // Dithering for 16 colors
                iidct(subf,subo);
                p=&panta[(is-oy)*640+((js-ox)<<2)];
                for (k=i=0;i<8;i++) {
                    for (j=0;j<4;j++) {
                        n=subo[k++]+128;
                        if (n<0) n=0; if (n>255) n=255;
                        *p=n&0xf0;
                        n=subo[k++]+128;
                        if (n<0) n=0; if (n>255) n=255;
                        *p|=n>>4;
                        *p++^=0xff;
                    }
                    p=&p[76];
                }
           }
        }
}
