	.text

	.globl _start
_start:	
	move.w	#0x2700,%sr             |Sin interrupciones
	lea.l	0xfffff000,%a0
	move.w	#0x2400,0x200(%a0)	|PLL Control
	move.b	#0x18,(%a0)		|System Control (no DMAP)
	move.w	#0,0xb0a(%a0)		|Disable WD
	move.b	#5,0x42b(%a0)		|PF Select
	move.b	#0x40,0x40b(%a0)	|PB Select

	move.w	#0x8600,0x100(%a0)	|CSA0 Base
	|move.w	#0x8097,0x110(%a0)	|CSA0 Control (RO)
	move.w	#0x8087,0x110(%a0)	|0 WS

	move.w	#0x8400,0x102(%a0)	|CSB0 Base = 0x10800000
	move.w	#0x8083,0x112(%a0)	|CSB0 Control (256K, RO)
	|move.w	#0,0x112(%a0)		|CSB0 invalido

	move.w	#0x8000,0x104(%a0)	|CSC0 Base = 0x10000000
	move.w	#0x5087,0x114(%a0)	|CSC0 Control (256K)
					|128K supervisor only

	move.w	#0x0000,0x106(%a0)	|CSD0 Base = 0
	|move.w	#0x809b,0x116(%a0)	|CSD0 Control (R0)
	move.w	#0x808b,0x116(%a0)	|0 WS

	move.w	#0x30,0x118(%a0)	|EMUCS

	move.b	#0,0xa27(%a0)		|LCD CLK off
	move.l	#0x1000,0xa00(%a0)	|LCD start address
	move.b	#0xa,0xa05(%a0)		|LCD virtual width
	move.w	#160,0xa08(%a0)		|LCD screen width
	move.w	#159,0xa0a(%a0)		|LCD screen height
	move.b	#8,0xa20(%a0)		|LCD interf. conf.
	move.b	#0x80,0xa29(%a0)	|LCD last buffer address
	move.b	#6,0xa25(%a0)		|LCD pixel CLK divider
	move.b	#0,0xa21(%a0)		|LCD pixel polarity
	move.b	#0,0xa1f(%a0)		|LCD blink control
	move.b	#0x81,0xa27(%a0)	|LCD CLK control
	
	move.b	#0,0x413(%a0)		|PC select
	move.b	#0,0x412(%a0)		|PC pull-down
	
	move.b	#0x40,0x409(%a0)	|PB DATA
	move.b	#0x40,0x408(%a0)	|PB DIR
	move.b	#0xBF,0x40A(%a0)	|PB Pull-up
	move.b	#0xFA,0x42A(%a0)	|PF Pull-up
	move.b	#0x05,0x428(%a0)	|PF DIR
	move.b	#0x05,0x42B(%a0)	|PF Select
	move.b	#0x04,0x429(%a0)	|PF DATA
	move.b	#0x00,0x40A(%a0)	|PB Pull-up
	move.b	#0x02,0x42A(%a0)	|PF Pull-up

	|move.w	#0x38,0x902(%a0)	|Baud=115200
	|move.w	#0x80,0x908(%a0)	|Control II
	|move.b	#0xe8,0x906(%a0)	|Ignore CTS
	|move.w	#0xe100,0x900(%a0)	|Control


	movea.l	#0x10040000,%sp

        lea.l   _etext,%a0      |Copiamos la seccion .data
        lea.l   _data,%a1       |a la RAM
        lea.l   _eeh_fram,%a2
L1:     cmpa.l  %a2,%a1
        beq     L2
        move.b  (%a0)+,(%a1)+
        bra     L1

	|Copiamos la seccion .data de las aplicaciones a RAM
L2:	move.l	0x10c20000,%a0
	move.l	0x10c20004,%a1
	move.l	0x10c20008,%a2
L3:     cmpa.l  %a2,%a1
        beq     L4
        move.b  (%a0)+,(%a1)+
        bra     L3

L4:	lea.l	__bss_start,%a0	|Borramos .bss
	lea.l	_end,%a1
1:	cmpa.l	%a1,%a0
	beq	2f
	clr.b	(%a0)+
	bra	1b

2:	jsr	init_vector
	jsr	init_lowio
	jsr	init_mem
	jsr	init_vt
	jsr	init_task
	jsr	init_irq

|-------------- IDLE task --------------

3:	move.b	#0x80,0xfffff207	|modo DOZE, CPU parada
	bra	3b

|-------------- Copia de la tabla de vectores ----------------


	.globl trap_table

trap_table:
	.long 0x10040000	|0 SSP inicial
        .long _start	|1 PC inicial
        .long ebus      |2 Error de bus
        .long edir      |3 Error de direccin
        .long eileg     |4 Cdigo ilegal
        .long div0      |5 Divisin por 0
        .long tchk	|6 CHK
        .long ttrapv	|7 TRAPV
        .long privi     |8 Instruccin privilegiada
        .long traza     |9 Paso a Paso
        .long emula     |a Emulador 1010
        .long emulf     |b Emulador 1111 (copro)
        .long trapn	|c
        .long trapn	|d
        .long trapn	|e
	.long trapn	|f
        .long trapn	|10
        .long trapn	|11
        .long trapn	|12
	.long trapn	|13
        .long trapn	|14
        .long trapn	|15
        .long trapn	|16
	.long trapn	|17
        .long trapn	|18
        .long trapn	|19
        .long trapn	|1a
	.long trapn	|1b
        .long trapn	|1c
        .long trapn	|1d
        .long trapn	|1e
	.long trapn	|1f
        .long sys_trap0	|20
        .long sys_trap1	|21
        .long sys_audio	|22
	.long sys_pwm	|23
        .long trapn	|24
        .long trapn	|25
        .long trapn	|26
	.long trapn	|27
        .long trapn	|28
        .long trapn	|29
        .long trapn	|2a
	.long trapn	|2b
        .long trapn	|2c
        .long trapn	|2d
        .long trapn	|2e
	.long trapn	|2f
        .long trapn	|30
        .long trapn	|31
        .long trapn	|32
	.long trapn	|33
        .long trapn	|34
        .long trapn	|35
        .long trapn	|36
	.long trapn	|37
        .long trapn	|38
        .long trapn	|39
        .long trapn	|3a
	.long trapn	|3b
        .long trapn	|3c
        .long trapn	|3d
        .long trapn	|3e
	.long trapn	|3f
        .long trapn	|40
        .long l1_isr	|41
        .long l2_isr	|42
	.long l3_isr	|43
        .long l4_isr	|44
        .long l5_isr	|45
        .long l6_isr	|46
	.long l7_isr	|47
	.long trapn	|48
        .long trapn	|49
        .long trapn	|4a
	.long trapn	|4b
        .long trapn	|4c
        .long trapn	|4d
        .long trapn	|4e
	.long trapn	|4f

	.section .novol
	.globl year
	.globl alyear

year:	.space 2
alyear:	.space 2
