#include "ip.h"
#include "config.h"

extern  unsigned int n_udp, n_tx_udp;


/** Contestamos con otro paquete UDP:
Intercambiamos Direcciones IP
Intercambiamos Puertos UDP
Ajustamos longitudes
Recalculamos CHECKSUM's **/

reply_udp(blk_udp *p,int n)
{
	unsigned int i;
	char *pchd;
	
	pchd=(char *)p; pchd+=2;	/* pchd apunta a la cabecera IP */

	n_tx_udp++;
	
	p->ip_dst_H=p->ip_src_H;
	p->ip_dst_L=p->ip_src_L;
	p->ip_src_H=IP_H;
	p->ip_src_L=IP_L;
	p->ip_TTL=MI_TTL;

	i = p->udp_src_port;
	p->udp_src_port = p->udp_dst_port;
	p->udp_dst_port = i;

	if (n==0) n=p->count-28;
	
	p->count=n+28;
	p->ip_total_len=p->count;
	p->udp_len=n+8;

	p->ip_CHK=0;
	p->udp_CHK=0;

	p->ip_CHK=checksum(pchd,10);	/* Checksum Cabecera IP */

	p->udp_CHK=0;
	
	/* All va la contestacin */

	for(;;) {
		i=put_tx_q((char *)p);
		en_tx_irq();
		if (i) break;
		sleep();
	}
	                                                                                
}


/***** Protocolo UDP *****/
void udp(blk_udp *p)
{
	n_udp++;
	
	/* Slo contestamos de momento a paquetes TFTP y ECHO */
	if (p->udp_dst_port==69) { tftp(p); return;}
	if (p->udp_dst_port==7) { reply_udp(p,0); return;}
	
	/* Y hacemos caso de los paquetes de configuracin */
	if (p->udp_dst_port==CONFIG_PORT) port_config(p);
	free_blk((char *)p);
}
