	.include "../include/hc11io.inc"
	.area	_CODE (REL)

;============= Rutinas para el cronometraje ===========

;INIT_TIMER: Habilita interrupcin de OC2
;Esta interrupcin debe producirse cada 10 ms


init_timer::
	ldx	#0x1000
	ldaa	#0x40
	staa	TCTL1,x		;OC2 toggle on CMP
	staa	TFLG1,x		;Clear any pending INT
	staa	TMSK1,x		;Enable OC2 INT
	clr	*timer		;Temporizador=0
	clr	*timer+1
	rts

;Rutina de interrupcin de OC2 (cada 10 ms)

timer_isr::
	ldx	#0x1000
	ldd	#25000		;Ciclos hasta nueva IRQ
	addd	TOC2,x
	std	TOC2,x
	bclr	TFLG1,x,#0xbf	;Borramos peticin IRQ
	ldd	*timer		;Actualizamos temporizador
	addd	#1
	std	*timer
	rti
