/** Definiciones de Trivial File Transfer Protocol **/

#ifndef	MTU
#define MTU 576
#endif

/* OPCODES de paquetes TFTP */

#define	OP_RRQ	1
#define OP_WRQ	2
#define OP_DATA	3
#define OP_ACK	4
#define OP_ERR	5

/* Cdigos de Error */

#define UNDEF			0
#define FILE_NOT_FOUND		1
#define	ACCESS_VIOLATION	2
#define	DISK_FULL		3
#define	ILLEGAL			4
#define	UNKNOWN_ID		5
#define	FILE_ALREADY_EXIST	6
#define	NO_SUCH_USER		7

/* Estructuras de Paquetes TFTP */

typedef struct {
	unsigned int	op;
	char	fname[MTU-30];
} tftp_rq;

typedef struct {
	unsigned int	op;
	unsigned int	blk;
	char	data[MTU-32];
} tftp_data;

typedef struct {
	unsigned int	op;
	unsigned int	blk;
} tftp_ack;

typedef struct {
	unsigned int	op;
	unsigned int	error;
	char		msg[MTU-32];
} tftp_err;

