#include "ip.h"
#include "tftp.h"
#include "proto.h"
#include "lib/libaux.h"

extern	unsigned int n_slip,n_ip, n_icmp, n_udp, n_tx_icmp, n_tx_udp;

int 	datacpy(char *dst, char *src, int nch, int cch, int n);

typedef struct {
	char 		*pointer;
	unsigned int 	count;
	unsigned char	type;
} FILE;

/* Definiciones de tipos de ficheros */

#define	L512	0	/* Menos de 512 bytes => 1 slo paquete */
#define MEM	1	/* Volcado de Memoria */
#define DATAF	2	/* Volcado de Datos ASCII */


FILE *fileopen(char *fn);

void tftp_error(blk_udp *pkt, int nerr, char *msg)
{
	tftp_err	*p_err;
	char		*p;
	p_err=(tftp_err *)pkt->data;
	p_err->op=OP_ERR;
	p_err->error=nerr;
	p=strcpy_m(p_err->msg,msg);
	reply_udp(pkt,(unsigned int)p - (unsigned int)p_err + 1);
}

/**************************************************************************/
typedef struct {
	unsigned int	ip_h;
	unsigned int	ip_l;
	unsigned int	src_port;
	unsigned int	timer;
	unsigned int	count;
	char		*pointer;
	unsigned int	blk;
	char		type;
	unsigned char	cch;
} TFTP_ENTRY;

#define NFILES 4
#define TIMEOUT 6000		/* 60 segundos */

static	TFTP_ENTRY open_files[NFILES];


void	tftp_init()
{
	int i;
	for (i=0;i<NFILES;i++) open_files[i].src_port=0;
}


/**************************************************************************/

void tftp(blk_udp *pkt)
{
	unsigned int i,j;
	char *dps,*dpd;
	FILE *f;
	TFTP_ENTRY *tp;
	
	tftp_rq		*p_rq;
	tftp_data	*p_data;
	tftp_err	*p_err;
	
	p_rq=(tftp_rq *)pkt->data;
	p_data=(tftp_data *)pkt->data;
	p_err=(tftp_err *)pkt->data;
	
	switch(p_rq->op) {
	case	OP_RRQ:
			f=fileopen(p_rq->fname);
			if (f->count==0) {
				tftp_error(pkt,FILE_NOT_FOUND,"File Not Found. See file index.");
				break;
			}
			if (f->count<512) {
				p_data->op=OP_DATA;
				p_data->blk=1;
				reply_udp(pkt,f->count+4);
				break;
			}
			for (i=0;i<NFILES;i++) {
				if (pkt->ip_src_H==open_files[i].ip_h &&
				    pkt->ip_src_L==open_files[i].ip_l &&
				    pkt->udp_src_port==open_files[i].src_port) break;
			}
			if (i==NFILES) {
				for (i=0;i<NFILES;i++) 
					if (open_files[i].src_port==0) break;
			}
			if (i==NFILES) {
				for (i=0;i<NFILES;i++) {
					j=timer-open_files[i].timer;
					if (j>TIMEOUT) break;
				}
			}
			if (i<NFILES) {
				tp=&open_files[i];
				tp->ip_h=pkt->ip_src_H;
				tp->ip_l=pkt->ip_src_L;
				tp->src_port=pkt->udp_src_port;
				tp->timer=timer;
				tp->count=f->count;
				tp->pointer=f->pointer;
				tp->blk=1;
				tp->type=f->type;
				p_data->op=OP_DATA;
				p_data->blk=1;
				if (tp->type==MEM)
					memcpy(p_data->data,tp->pointer,512);
				else if (tp->type==DATAF)
					tp->cch=datacpy(p_data->data,tp->pointer,nchannels,0,512);
				reply_udp(pkt,512+4);
			} else {
				tftp_error(pkt,NO_SUCH_USER,"Too Many Users");
			}
			break;
	case	OP_WRQ:
			tftp_error(pkt,ACCESS_VIOLATION,"No WRITE Allowed");
			break;
	case	OP_DATA:
	case	OP_ERR:
			tftp_error(pkt,ILLEGAL,"Unexpected ID");
			break;
	case	OP_ACK:
			for (i=0;i<NFILES;i++) {
				if (pkt->ip_src_H==open_files[i].ip_h &&
				    pkt->ip_src_L==open_files[i].ip_l &&
				    pkt->udp_src_port==open_files[i].src_port) break;
			}
			if (i==NFILES) { 
				free_blk((char *)pkt);
			} else {
				tp=&open_files[i];
				
				tp->timer=timer;

				if (p_data->blk==tp->blk) {
					/* N de secuencia correcto */
					tp->count-=512;
					if (tp->type==MEM)
						tp->pointer+=512;
					else if (tp->type==DATAF) {
						tp->pointer+=128;
						if (tp->pointer>=DATA_TOP)
							tp->pointer-=DATA_LEN;
					}
					tp->blk++;
				}
				
				/* Si el nmero no es correcto se reenva */
				j=tp->count;
				if (j<512) tp->src_port=0;
				else j=512;

				if (j)
				    if (tp->type==MEM)
					memcpy(p_data->data,tp->pointer,j);
				    else if (tp->type==DATAF)
					tp->cch=datacpy(p_data->data,tp->pointer,nchannels,tp->cch,j);
				
				p_data->op=OP_DATA;
				p_data->blk=tp->blk;
				reply_udp(pkt,j+4);
			}
			break;
	default:	
			tftp_error(pkt,UNKNOWN_ID,"Unknown ID");
			break;
	}
}


/*******************************************************************
			Gestin de FICHEROS
*******************************************************************/


static char *filelist[]={
	"mem/0000",
	"mem/2000",
	"mem/4000",
	"mem/6000",
	"mem/8000",
	"mem/a000",
	"mem/c000",
	"mem/e000",
	"mem/ram",		/* 8 */
	"mem/io",		/* 9 */
	"mem/eeprom",		/* 10 */
	"index",		/* 11 */
	"stat",			/* 12 */
	"about",		/* 13 */
	"data",			/* 14 */
	"alldata",		/* 15 */
	NULL
};

/* fileopen: busca un nombre de fichero y puede retornar datos. Si no
se encuentra el fichero se retorna fileopen()->count=0. */

FILE *fileopen(char *fn){
	static FILE file;
	unsigned int i,j,*tp;
	char *p;
	unsigned char *pp;

	for (i=0;filelist[i]!=NULL;i++) {
		if (strcmp(filelist[i],fn)==0) break;
	}
	if (filelist[i]==NULL) {	/* No se encontr */
		file.count=0;
		return &file;
	}
	if (i<8) {		/* Casos: mem/X000 */
		file.count=8192;
		file.pointer=(char *)(i<<13);
		file.type=MEM;
		return &file;
	}
	switch(i) {
	case 8:				/* mem/ram */
		memcpy(fn+2,NULL,256);
		file.count=256;
		file.type=L512;
		return &file;
	case 9:				/* mem/io */
		memcpy(fn+2,(char *)0x1000,0x40);
		file.count=0x40;
		file.type=L512;
		return &file;
	case 10:			/* mem/eeprom */
		file.count=512;
		file.pointer=(char *)0xb600;
		file.type=MEM;
		return &file;
	case 11:			/* index */
		p=fn+2;
		p=strcpy_m(p,"\nHC11 directory:\n---------------\n");
		for (i=0;filelist[i]!=NULL;i++) {
			p=strcpy_m(p,filelist[i]);
			p=strcpy_m(p,"\n");
		}
		file.count=(unsigned int)p-(unsigned int)fn-2;
		file.type=L512;
		return &file;
		
	case 12:			/* stat */
		p=fn+2;
		tp=tsk0_cnt;
		p=strcpy_m(p,"\nCPU Time (clocks):\n");
		for (i=0;i<4;i++) {
			p+=sprintf(p,"Task %u: 0x%04X%04X%04X\n",
				i,*tp,*(tp+1),*(tp+2));
			tp+=4;
		}
		
		p=strcpy_m(p,"\nReceived Packets:\n");
		p+=sprintf(p,"SLIP:\t%u\nIP:\t%u\nICMP:\t%u\nUDP:\t%u\n",
			n_slip,n_ip,n_icmp,n_udp);
		p=strcpy_m(p,"\nSent Packets:\n");
		p+=sprintf(p,"ICMP:\t%u\nUDP:\t%u\n",n_tx_icmp,n_tx_udp);
		p=strcpy_m(p,"\nOpen TFTP's:\n");
		for (i=0;i<NFILES;i++) {
			if (open_files[i].src_port){
				pp=(char *)&open_files[i].ip_h;
				for (j=4;j;j--) {
					p+=sprintf(p,"%u.",*pp++);
				}
				j=timer-open_files[i].timer;
				p+=sprintf(--p,":%u Count=%u Idle=%u seg ",
				open_files[i].src_port,open_files[i].count,j/100);
				if (j>TIMEOUT) p+=sprintf(p,"TIMEOUT\n"); else p+=sprintf(p,"\n");
			}
		}
		p=strcpy_m(p,"\nFree Buffers: ");
		pp=flags_blk;
		for (j=0,i=NBLK;i;i--) if (*pp++==0)j++;
		p+=sprintf(p,"%u\n",j);
		
		p+=sprintf(p,"\nNdata = %u/%u\nSample Period = %u0 (ms)\nMask = %08b\n",
		  ndata,maxdata,sample_time,chmask);

		file.count=(unsigned int)p-(unsigned int)fn-2;
		file.type=L512;
		return &file;
		
	case 13:			/* about */
		p=strcpy_m(fn+2,about_msg);
		file.count=(unsigned int)p-(unsigned int)fn-2;;
		file.type=L512;
		return &file;

	case 14:			/* data */
		p=fn+2;
		p+=sprintf(p,"# Channels 0 to 7. Last values:\n");
		for (i=0;i<8;i++) {
			p+=sprintf(p,"%4d",current_data[i]);
		}
		p+=sprintf(p,"\n");
		file.count=(unsigned int)p-(unsigned int)fn-2;
		file.type=L512;
		return &file;
	case 15:			/* alldata */
		file.count=ndata*nchannels;
		file.pointer=datap;
		file.pointer-=file.count;
		if(file.pointer<DATA) file.pointer+=DATA_LEN;
		file.count<<=2;
		if (file.count>=512)
			file.type=DATAF;
		else {
			file.type=L512;
			datacpy(fn+2,file.pointer,nchannels,0,file.count);
		} 
		return &file;

	default:
		file.count=0;
		return &file;	
	}
}


int	datacpy(char *dst, char *src, int nch, int cch, int n)
{
	int i,j;
	
	n>>=2;			/* El n de datos es 1/4 del n de bytes */

	for (j=n;j;j--) {
		dst+=sprintf(dst,"%3u ",*src);
		src++;
		if (src>=DATA_TOP) src-=DATA_LEN;
		cch++;
		if (cch==nch) {
			cch=0;
			*(dst-1)='\n';	/* Cambiamos ltimo espacio por NL */
		}
	}
	return cch;
}
