	.include "../include/hc11io.inc"
	.area	_CODE (REL)

;============= Rutinas relacionadas con la multitarea ===========

;INIT_RTI: Habilita interrupcin de tiempo real
;Divisor=4 => frecuencia RTI = 76.29 Hz (13.11 ms)
;Esta rutina debe llamarse antes de los primeros 64 ciclos de reloj

init_rti::
	ldx	#0x1000
	ldaa	#0x40
	staa	TMSK2,x		;Activamos Int. y ponemos prescaler=0
	ldaa	#0x2
	staa	PACTL,x		;Divisor = 4 * 2^13
	ldd	TCNT,x		;valor inicial del reloj
	std	*clocks
	rts

;
;INIT_TSK: Establece los puntos de entrada a las tareas. La tarea 0 (ms
;prioritaria) no se establece, ya que es la actual
;
;Se borran los acumuladores de CPU de 48 bits de las tareas
;
	stk_1=0xffd6-64
	stk_2=stk_1-128
	stk_null=stk_2-64

tsk_tbl:
	.dw	stk_1,_main_IP
	.dw	stk_2,main2
	.dw	stk_null,tsk_null
	.dw	0,0

init_tsk::
	ldd	#0
	std	*tsk0_cnth	;Contador de CPU en 0
	std	*tsk0_cntm
	std	*tsk0_cntl
	ldy	#tsk_tbl
	ldx	#tsk1_sp	;tarea 1
btsk:	ldd	,y		;SP de tarea
	beq	ftsk
	std	,x		;a la tabla de tareas
	pshx
	xgdx			;X=SP de la tarea
	ldd	2,y		;D=PC de la tarea
	std	8,x
	clr	1,x		;CCR de la tarea=0
	pulx			;X=tabla de tareas
	ldd	#0
	std	2,x		;Contador CPU = 0
	std	4,x
	std	6,x
	ldab	#4
	abx
	abx			;nueva tarea
	aby
	bra	btsk
ftsk:	clr	*tsk_curr	;Estamos en la tarea 0
	rts

;---------------------------------------------------------------------------
;Tareas que no hacen sino conmutar inmediatamente de tarea
;---------------------------------------------------------------------------
main2:
	swi
	bra	main2

;---------------------------------------------------------------------------
;TSK_NULL: Tarea que consume el tiempo de CPU sobrante
;---------------------------------------------------------------------------
tsk_null:
	wai		;As respondemos antes a las interrupciones
	bra	tsk_null

;---------------------------------------------------------------------------
;RTI_ISR: Rutina de interrupcin peridica: 76.294 Hz (13.131 ms)
;Realiza una conmutaccin a la tarea 0 (la ms prioritaria)
;---------------------------------------------------------------------------

rti_isr::
	ldx	#0x1000
	bset	TFLG2,x,#0x40   ;Reconocimiento de INT.

	ldab	*tsk_curr	;Tarea actual
	lslb
	lslb
	lslb
	ldx	#tsk_table
	abx
	ldd	0x1000+TCNT
	psha
	pshb
	subd	*clocks		;Pulsos de reloj desde la ltima conmutacin
	addd	6,x		;Acumulamos pulsos de reloj
	std	6,x
	bcc	ris1
	inc	5,x
	bne	ris1
	inc	4,x
	bne	ris1
	inc	3,x
	bne	ris1
	inc	2,x
ris1:	pulb
	pula
	std	*clocks
	sts	,x
	clr	*tsk_curr	;Pasamos a tarea 0
	lds	*tsk0_sp
	rti

;---------------------------------------------------------------------------
;SWI_ISR: Rutina de conmutacin de tarea por software: Pasa a la siguente
;tarea menos prioritaria
;---------------------------------------------------------------------------

swi_isr::
	ldab	*tsk_curr	;Tarea actual
	lslb
	lslb
	lslb
	ldx	#tsk_table
	abx
	ldd	0x1000+TCNT
	psha
	pshb
	subd	*clocks		;Pulsos de reloj desde la ltima conmutacin
	addd	6,x		;Acumulamos pulsos de reloj
	std	6,x
	bcc	sis1
	inc	5,x
	bne	sis1
	inc	4,x
	bne	sis1
	inc	3,x
	bne	sis1
	inc	2,x
sis1:	pulb
	pula
	std	*clocks
	sts	,x		;Guardamos SP de tarea actual
	inc	*tsk_curr	;Pasamos a la siguiente tarea
	lds	8,x
	rti

;-------------------------------------------------------------------------
;Interface C
;-------------------------------------------------------------------------
;
; Rutina que cambia de tarea. (REENTRANTE)

_sleep::	swi
		rts
