	.include "../include/hc11io.inc"

	MTU=576

;	Special SLIP/KISS Characters

	FEND=0o300	;0xC0
	FESC=0o333	;0xDB
	TFEND=0o334	;0xDC
	TFESC=0o335	;0xDD


;*********************** rea de cdigo *********************

	.area	_CODE (REL)



;----------------- Inicializacin del puerto serie SCI ------------------

init_sci::
	psha
	pshx
	clr	*rx_status	;Estados iniciales conocidos
	clr	*tx_status
	ldx	#0x1000
	bset	SPCR,x,#0x20	;Put port D in wire or mode
	ldaa	#0x03		;Init SCI & BAUD (19200 baudios)
	staa	BAUD,x
	ldaa	#0x2c		;Enable RX & TX, Enable RX IRQ
	staa	SCCR2,x
	pulx
	pula
	rts

;---------------- Habilita interrupcin de transmisin -------------------

_en_tx_irq::
en_tx_irq::
	pshx
	ldx	#0x1000
	bset	SCCR2,x,#0x80   ; Habilitamos IRQ TX
	pulx
	rts

;************************************************************************
;------------------------------------------------------------------------
;-------------- Rutina de interrupcin del puerto serie -----------------
;------------------------------------------------------------------------
;************************************************************************

sci_isr::
	ldx     #0x1000			;Zona de registros E/S
	brset   SCSR,x,#0x20,irqrx	; IRQ RX ?
	brset   SCSR,x,#0x80,irqtx	; IRQ TX ?

;-------------------------------------------------------------------------
;---------------------------------- RX -----------------------------------
;-------------------------------------------------------------------------

irqrx:	ldaa	SCDR,x		; Esto ademas de leer el dato borra IRQ RX
	ldab	*rx_status
	lslb			;Status*2
	ldx	#rxjtbl
	abx
	ldx	,x
	jmp	,x
rxjtbl:	.dw	rx_st0
	.dw	rx_st1
	.dw	rx_st2

;-----------------
rx_st0:	;Estado 0: An no se ha recibido el caracter FEND
	cmpa	#FEND
	bne	op_rti
	;Hemos recibido FEND, hay que preparar la recepcin del paquete
	jsr	alloc_blk
	beq	op_rti		;Si no hay memoria adios paquete
	stx	*rx_buf_base
	clr	,x		;Contador de bytes en 0
	inx
	clr	,x
	inx
	stx	*rx_buf_curr
	inc	*rx_status	;Pasamos a estado 1
op_rti:	rti

;-----------------
rx_st1:	;Estado 1: Recepcin normal de caracteres de paquete SLIP
	cmpa	#FEND
	bne	rs1
	ldx	*rx_buf_base
	ldd	,x		;Lleg FEND: se acaba el paquete
	beq	op_rti		;Si el paquete est vaco ignoramos FEND
	jsr	put_rx_q	;En otro caso pasamos el paquete a la cola RX
	clr	*rx_status	;y pasamos a estado 0
	rti
rs1:	cmpa	#FESC
	bne	rs2
	inc	*rx_status	;Hemos recibido FESC => a estado 2
	rti
rs2:	ldx	*rx_buf_base	;Los caracteres "normales" al buffer
	psha
	ldd	,x		;Miramos si el bloque est lleno (Count>=MTU)
	cpd	#MTU
	bne	rs3
	pula
	rti
rs3:	pula
	ldx	*rx_buf_curr
	staa	,x		;Guardamos el caracter
	inx			;Incrementamos puntero
	stx	*rx_buf_curr
	ldx	*rx_buf_base
	inc	1,x		;Incrementamos Count
	bne	op_rti
	inc	,x
	rti
;-----------------
rx_st2:	;Estado 2: Se ha recibido FESC y esperamos por TFEND o TFESC
	dec	*rx_status	;Pasamos al estado 1
	cmpa	#TFEND
	bne	rs4
	ldaa	#FEND
	bra	rs2
rs4:	cmpa	#TFESC
	bne	rs2		;Si no es TFESC ni TFESC lo metemos al bloque
	ldaa	#FESC
	bra	rs2

;-----------------------------------------------------------------------
;--------------------------------- TX ----------------------------------
;-----------------------------------------------------------------------

irqtx:	ldab	tx_status
	lslb			;Status*2
	ldx	#txjtbl
	abx
	ldx	,x
	jmp	,x
txjtbl:	.dw	tx_st0
	.dw	tx_st1
	.dw	tx_st2
	.dw	tx_st3

;-----------------
tx_st0:	;Estado 0: Comenzamos transmisin:
	jsr	get_tx_q
	bne	ts1
	ldx	#0x1000		;Si no hay nada que transmitir
	bclr	SCCR2,x,#0x80	;Inhabilita IRQ TX
	rti
ts1:	stx	*tx_buf_base	;Guardamos informacin del buffer
	ldd	,x
	std	*tx_count
	inx
	inx
	stx	*tx_buf_curr
	ldaa	#FEND		;Transmitimos FEND(comienzo de paquete)
	inc	*tx_status	;Pasamos a estado de transmisin normal
ts4:	staa	SCDR+0x1000	;Dato -> SCI, ademas borramos IRQ TX
	rti

;-----------------
tx_st1:	;Estado 1: Transmitimos Datos en modo normal
	ldd	*tx_count
	bne	ts2
	clr	*tx_status	;Se acabaron los datos
	ldx	*tx_buf_base	;Liberamos el bloque
	jsr	free_blk
	ldaa	#FEND		;Transmitimos FEND
	bra	ts4

ts2:	subd	#1
	std	*tx_count
	ldx	*tx_buf_curr
	ldaa	,x
	inx
	stx	*tx_buf_curr	;Actualizamos puntero a buffer
	cmpa	#FEND
	bne	ts3
	inc	*tx_status	;Pasamos al estado 2 y
	ldaa	#FESC		;transmitimos FESC
	bra	ts4

ts3:	cmpa	#FESC
	bne	ts4
	inc	*tx_status	;Pasamos al estado 3 y
	inc	*tx_status
	ldaa	#FESC		;transmitimos FESC
	bra	ts4

;-----------------
tx_st2:	;Estado 2: Se ha transmitido FESC por FEND
	dec	*tx_status
	ldaa	#TFEND
	bra	ts4

;-----------------
tx_st3:	;Estado 3: Se ha transmitido FESC por FESC
	dec	*tx_status
	dec	*tx_status
	ldaa	#TFESC
	bra	ts4

