	MTU2=576+2	;Tamao del bloque
	NBLK=7		;N de bloques
	NEQ=8		;N de entradas en las colas RX y TX

;Reservamos 4 Kb de la RAM auxiliar para paquetes y colas.
;Organizamos estos 4 Kb como una "piscina" de bloques de un tamao mximo
;de 576 bytes. Esto nos permite un mximo de 7 bloques y sobran 50 bytes para
;las colas y dems.
;Los 2 primeros bytes de cada bloque contienen el nmero de bytes del bloque
;
;Utilizaremos una lista de Flags para buscar de forma rpida los
;bloques libres y ;para liberarlos.

	.area	AUXMEM (ABS)
	.org	0xc000

poolbase:	.ds	MTU2*NBLK
tx_q::		.ds 	NEQ*2	;cola TX: (16 entradas)
tx_top::
rx_q::		.ds	NEQ*2	;cola RX: (16 entradas)
rx_top::
_flags_blk::
flags_blk::	.ds	NBLK

	.org	0xd000

_DATA::		.ds	4096
_DATA_TOP::

;============================ RUTINAS ===================================
	.area	_CODE (REL)

;INIT_MEM: Prepara todos los bloques

init_mem::
	ldx	#flags_blk
	ldaa	#NBLK
imb1:	clr	,x
	inx
	deca
	bne	imb1
	rts

;ALLOC_BLK: Busca un bloque libre
;Retorna un puntero al bloque en X
;Retorna ZF=1 si no queda memoria

alloc_blk::
	psha
	pshb
	pshy
	ldy	#NBLK
	ldx	#flags_blk
	ldd	#poolbase
abb1:	sei		;Hacemos atmica la prueba y set del flag
	tst	,x
	beq	abf1
	cli
	inx
	addd	#MTU2
	dey
	bne	abb1
	bra	abf2	;(ZF=1)
abf1:	inc	,x	;Marcamos el bloque como ocupado (ZF=0)
	cli
	xgdx		;No cambia ZF 
abf2:	puly
	pulb
	pula
	rts

_alloc_blk::		;Interface C
	pshx
	bsr	alloc_blk
	bne	_abs1
	ldx	#0
_abs1:	stx	*ZD0
	pulx
	rts
	
;FREE_BLK: Marca un bloque como libre
;Entrada:	X=Puntero al bloque (dentro del bloque)

free_blk::
	psha
	pshb
	pshx
	ldd	#MTU2
	xgdx
	subd	#poolbase
	idiv			;X=N del bloque
	xgdx
	ldx	#flags_blk
	abx			;X=Puntero al flag
	clr	,x
	pulx
	pulb
	pula
	rts

_free_blk::		;Interface C
	pshx
	ldx	*ZD0
	bsr	free_blk
	pulx
	rts
