	.area _BSS (REL)

base:	.ds 2	; Base numrica para impresin.(10 ->decimal, 2 -> binario...)
ndig:	.ds 1	; N de dgitos del nmero
fill:	.ds 1	; 0 rellenar con 0's. 1 rellenar con espacios

buff:	.ds 20	; Buffer temporal para el nmero
	.ds  1	; Terminador del buffer (0)

spoint:	.ds 2	; Puntero a la cadena destino (sprintf)

	.area _CODE (REL)

;*****************************************************************************
; Rutina para imprimir nmeros en cualquier base
;
;	Registro D (A:B) : Nmero que se imprime
;
;	base (16 bits) : Base en la que se imprime
;	ndig (8 bits)  : Nmero de caracteres mnimo que se imprimen
;	fill (8 bits)  0 : Rellenar a la izquierda con 0's
;		    otro : Rellenar a la izquierda con espacios
;*****************************************************************************

prtn:	psha
	pshb
	pshx
	pshy
	ldy #(buff+19)
	xgdx
	clrb		;Terminamos el buffer con ascii 0
	stab buff+20
	ldaa ndig	;copia temporal
	psha
	xgdx
	cpd #0		;Si D==0 por lo menos hay que escribir un cero
	bne prtn1
	ldaa #'0
	staa 0,y
	dey
	clra
	dec ndig
prtn1:	cpd #0
	bne nedig	;Terminamos si cociente=0 y ndig=0
	tst ndig
	beq pprtn
nedig:	ldx base
	idiv	;D=resto, X=cociente
	cmpb #9
	ble numero
	addb #7		;Letra
numero:	addb #'0
	cmpb #'0	; Si 0 y cociente=0 y fill=espacio
	bne pdig
	cpx #0
	bne pdig
	tst fill
	beq pdig
	ldab #32	;espacio
pdig:	stab 0,y
	dey
	xgdx		;D=cociente
	tst ndig
	beq prtn1	;si ndig>0 ndig--
	dec ndig
	bra prtn1
pprtn:	iny		;y -> apunta al primer dgito
pprtn1:	ldaa 0,y
	beq prtnf
	jsr s_putchar
	iny
	bra pprtn1
prtnf:	pula
	staa ndig
	puly
	pulx
	pulb
	pula
	rts


;***************************************************************************
; sprintf
;***************************************************************************
;	Formatos soportados:
;
;	<n>=  N de digitos (Rellenar con espacio)
;	0<n>= N de digitos (Rellenar con ceros)
;
;	%u, %<n>u, %0<n>u  Decimal sin signo.	Ejemplos: %05u %12u	
;	%d, %<n>d, %0<n>d  Decimal con signo.	Ejemplos: %05d %d
;	%o, %<n>o, %0<n>o  Octal.		Ejemplos: %04o %14o
;	%x, %<n>x, %0<n>x  Hexadecimal.		Ejemplos: %04x %2x
;	%b, %<n>b, %0<n>b  Binario.		Ejemplos: %08b %16b
;	%c		   Caracter.
;	%s		   Cadena.
;

_sprintf::
	psha
	pshb
	pshx
	pshy
	tsx
	xgdx
	addd #10
	xgdy		;Y puntero a parmetros
	tsx
	ldx 8,x		;X Puntero a cadena de formato
	ldd *ZD0	;Puntero a cadena destino
	std spoint
bprtf1:	ldaa 0,x
	bne sprt1
	jmp prtff
sprt1:	inx
	cmpa #'%
	beq sprt2
	jmp nprt1
sprt2:		ldaa #1
		staa ndig
		staa fill
		ldaa 0,x
		bne sprt3
		jmp prtff
sprt3:		inx
		cmpa #'0
		bne nprt3
			clr fill	;Cero?
			ldaa 0,x
			bne sprt4
			jmp prtff
sprt4:			inx
			cmpa #'0
			blt nprt5
			cmpa #'9
			bhi nprt5
nprt4:				suba #'0
				staa ndig
				ldaa 0,x
				bne sprt5
				jmp prtff
sprt5:				inx
				cmpa #'0
				blt nprt5
				cmpa #'9
				bhi nprt5
nprt44:					suba #'0
					ldab ndig	;ndig=ndig*10
					lslb
					lslb
					addb ndig
					lslb
					aba		;ndig=ndig*10+a
					staa ndig
					ldaa 0,x
					bne sprt6
					jmp prtff
sprt6:					inx
nprt3:		cmpa #'0	;Nmero?
		bls nprt5
		cmpa #'9
		ble nprt4

nprt5:		cmpa #'u
		bne nprt6
			bra nprt511
nprt51:			ldaa #32
nprt52:			jsr s_putchar	;espacio para signo
nprt511:		ldd #10
nprt55:			std base
			ldd 0,y
			iny
			iny
			jsr prtn
			jmp bprtf1
nprt6:		cmpa #'d
		bne nprt7
			ldd 0,y
			bpl nprt51
			ldd #0
			subd 0,y
			std 0,y
			ldaa #'-
			bra nprt52
nprt7:		cmpa #'x
		bne nprt8
nprt71:			ldd #16
			bra nprt55
nprt8:		cmpa #'X
		bne nprt9
			bra nprt71
nprt9:		cmpa #'b
		bne nprt10
			ldd #2
			bra nprt55
nprt10:		cmpa #'o
		bne nprt11
			ldd #8
			bra nprt55
nprt11:		cmpa #'c
		bne nprt12
			ldd 0,y
			iny
			iny
			tba
			jsr s_putchar
			jmp bprtf1
nprt12:		cmpa #'s
		bne nprt1
			pshx
			ldx 0,y
			iny
			iny
nprt121:		ldaa 0,x
			beq nprt122
			jsr s_putchar
			inx
			bra nprt121
nprt122:		pulx
			jmp bprtf1
nprt1:	jsr s_putchar
	jmp bprtf1

prtff:	ldd	spoint	;Retorna el N de bytes escritos
	subd 	*ZD0
	std	*ZD0
	puly
	pulx
	pulb
	pula
	rts

;*****************************************************************
; putchar para cadenas
;*****************************************************************
s_putchar:
	pshx
	ldx spoint
	staa 0,x
	clr  1,x	;Para terminar adecuadamente la cadena
	inx
	stx spoint
	pulx
	rts
