	.area _CODE (REL)
;
;_MEMCPY: Copia bloques de datos
;Interface C: void memcpy(char *s1, char *s2, int n);
;
;Stack Trace:
;SP+6	->COUNT
;SP+4	->SRC
;SP+2	->PC
;SP+0	->Y

_memcpy::
	pshy
	tsy
	pshx
	psha
	pshb
	ldd	*ZD0	;Guardamos ZD0 en la pila
	psha
	pshb
	ldx	4,y	;X=src
	ldd	6,y
	ldy	*ZD0	;Y=dst
	lsrd		;D=count/2
	std	*ZD0	;ZD0=count
	bcc	bcpy
	ldaa	,x	;Si el nmero de bytes era impar
	staa	,y	;copiamos el primero
	inx
	iny
bcpy:	ldd	,x	;copiamos palabras de 16 bits para acelerar
	std	,y
	ldab	#2
	abx
	aby
	dec	*ZD0+1	;cnt_LSB--
	bne	bcpy
	tst	*ZD0	;cnt_MSB==0?
	beq	scpy	;si LSB y MSB =0 se acab
	dec	*ZD0	;cnt_MSB--
	bra	bcpy
scpy:	pulb
	pula
	std	*ZD0	;Recuperamos ZD0
	pulb
	pula
	pulx
	puly
	rts
 