#define	IP_H	0x9d58	/* 157.88 -> 0x9d58*/
#define IP_L	0x6ff5	/* 111.245 -> 0x6ff5*/

#define MI_TTL	64

/****************************************************/

#define MTU	576

typedef struct {
	unsigned int	count;
	
	unsigned char	version_IHL;
	unsigned char	type_service;
	unsigned int	total_len;
	unsigned int	ID;
	unsigned int	flags_frag_off;
	unsigned char	TTL;
	unsigned char	protocol;
	unsigned int	CHK;
	unsigned int	src_H;
	unsigned int	src_L;
	unsigned int	dst_H;
	unsigned int	dst_L;

	char		data[MTU-20];
} blk_ip;


typedef struct {
	unsigned int	count;
	
	unsigned char	ip_version_IHL;
	unsigned char	ip_type_service;
	unsigned int	ip_total_len;
	unsigned int	ip_ID;
	unsigned int	ip_flags_frag_off;
	unsigned char	ip_TTL;
	unsigned char	ip_protocol;
	unsigned int	ip_CHK;
	unsigned int	ip_src_H;
	unsigned int	ip_src_L;
	unsigned int	ip_dst_H;
	unsigned int	ip_dst_L;

	unsigned char	icmp_type;
	unsigned char	icmp_code;
	unsigned int	icmp_CHK;
	unsigned int	icmp_ID;
	unsigned int	icmp_SEQ_N;

	char		data[MTU-28];
} blk_icmp_echo;


typedef struct {
	unsigned int	count;
	
	unsigned char	ip_version_IHL;
	unsigned char	ip_type_service;
	unsigned int	ip_total_len;
	unsigned int	ip_ID;
	unsigned int	ip_flags_frag_off;
	unsigned char	ip_TTL;
	unsigned char	ip_protocol;
	unsigned int	ip_CHK;
	unsigned int	ip_src_H;
	unsigned int	ip_src_L;
	unsigned int	ip_dst_H;
	unsigned int	ip_dst_L;

	unsigned int	udp_src_port;
	unsigned int	udp_dst_port;
	unsigned int	udp_len;
	unsigned int	udp_CHK;
	
	char		data[MTU-28];

} blk_udp;
