#include "ip.h"
#include "proto.h"

extern void icmp(blk_icmp_echo *psrc);

extern void udp(blk_udp *p);

extern void tftp_init();

/**** Variables contadores de paquetitos *****/

extern unsigned int n_slip, n_ip, n_icmp, n_udp, n_tx_icmp, n_tx_udp;

/**** Rutina filtro de IP y selector de protocolo de nivel superior ****/

void ip(blk_ip *pkt)
{
	
	if (pkt->version_IHL != 0x45)	{ free_blk((char *)pkt); return; }
	pkt->flags_frag_off &=~4000;
	if (pkt->flags_frag_off)	{ free_blk((char *)pkt); return; }

	if (pkt->src_H == IP_H && pkt->src_L == IP_L)
					{ free_blk((char *)pkt); return; }

	if (pkt->dst_H != IP_H)		{ free_blk((char *)pkt); return; }
	if (pkt->dst_L != IP_L)		{ free_blk((char *)pkt); return; }
	n_ip++;
	if (pkt->protocol ==1)		{ icmp((blk_icmp_echo *)pkt); return; }
	if (pkt->protocol ==17)		{ udp((blk_udp *)pkt); return; }
	free_blk((char *)pkt);
}


main_IP()
{
	blk_ip	*p;
	
	n_slip=n_ip=n_icmp=n_udp=n_tx_icmp=n_tx_udp=0;
	
	tftp_init();
	
	for (;;) {

		/* Esperamos que llegue un PKT */
		while ((p=(blk_ip *)get_rx_q())==NULL) sleep();

		n_slip++;
		/* Procesamos paquete IP */
		ip(p);
		
	}
}

