#include "ip.h"
#include "proto.h"

extern unsigned n_icmp, n_tx_icmp;

/***** Protocolo ICMP: ECHO_REQUEST y ECHO_REPLY *****/

void icmp(blk_icmp_echo *p)
{
	char		*pchd;
	unsigned int	i;

	n_icmp++;
	
	pchd=(char *)p; pchd+=2;	/* pchd apunta a cabecera IP */
	
	if(p->icmp_type !=8) { free_blk((char *)p); return; } /* ECHO REQ */
	if(p->icmp_code) { free_blk((char *)p); return; }

	
	/* Contestamos con otro paquete con datos idnticos */
	n_tx_icmp++;

	p->ip_CHK=0;
	p->icmp_CHK=0;
	p->ip_dst_H = p->ip_src_H;
	p->ip_dst_L = p->ip_src_L;
	p->ip_src_H = IP_H;
	p->ip_src_L = IP_L;
	p->ip_TTL=MI_TTL;
	p->icmp_type=0;
	
	if (p->count & 1) pchd[p->count]=0; /* Para el clculo del CHK */
	
	p->ip_CHK=checksum(pchd,10);		/* Checksum IP */

	p->icmp_CHK=checksum(pchd,(p->count+1)>>1);	/* Checksum ICMP */
	
	/* All va la contestacin */
	
	for(;;) {
		i=put_tx_q((char *)p);
		en_tx_irq();
		if (i) break;
		sleep();
	}
}
