/* Este programa se ejecuta como la tarea N 0, por lo que no es posible
la llamada a funciones no-reentrantes (sprintf, strXXX,...,etc), ni 
siquiera de la libgcc.a, lo que prohibe operaciones de multiplicacin y
divisin */

#include "proto.h"

#define MIN_SAMPLE_TICS	3	/* muestras/seg mnimo */

/*------- Definicin de los pseudoregistros de esta tarea --------*/
asm("
	BASE=0		;TASK 0

	ZD0=BASE
	ZD1=BASE+2
	ZD2=BASE+4
	ZD3=BASE+6
	ZD4=BASE+8
	ZD5=BASE+10
	ZD6=BASE+12
	ZD7=BASE+14
	ZD8=BASE+16

	ZB0=BASE+18
	ZB1=BASE+19
	ZB2=BASE+20
	ZB3=BASE+21
	ZB4=BASE+22

	ZXT=BASE+23
");

void adquire();

asm("
	.area _CODE(REL)
	
_adquire::
	psha
	pshx
	ldx	#0x1000
	ldaa	#0x10	;Canales 0-3
	staa	0x30,x	;ADCTL
	swi		; sleep until done
adlb0:	brclr	0x30,x,#0x80,adlb0
	ldaa	0x31,x
	staa	*_current_data+0
	ldaa	0x32,x
	staa	*_current_data+1
	ldaa	0x33,x
	staa	*_current_data+2
	ldaa	0x34,x
	staa	*_current_data+3
	ldaa	#0x14	;Canales 4-7
	staa	0x30,x	;ADCTL
	swi		; sleep until done
adlb1:	brclr	0x30,x,#0x80,adlb1
	ldaa	0x31,x
	staa	*_current_data+4
	ldaa	0x32,x
	staa	*_current_data+5
	ldaa	0x33,x
	staa	*_current_data+6
	ldaa	0x34,x
	staa	*_current_data+7
	pulx
	pula
	rts

");

void main_AD()
{
	unsigned int i,j,k,t0;
	char msk,*p;
	
	/* Configuracin coherente */
	
	if (sample_time<MIN_SAMPLE_TICS) sample_time=MIN_SAMPLE_TICS;
	if (chmask) {
		for(k=chmask,i=j=0;i<8;i++) {
			if (k&1) j++;
			k>>=1;
		}
		nchannels=j;
		/* No se puede dividir */
		for(i=j=0;i<DATA_LEN;i+=nchannels) j++;
		maxdata=j;
	} else {
		chmask=1;
		nchannels=1;
		maxdata=DATA_LEN;
	}
	ndata=0;
	datap=DATA;

	/* Activamos bomba de carga A/D */
	asm("
		pshx
		ldx	#0x1000
		bset	0x39,x,#0x80
		pulx
	");
	
	t0=timer;
	for(;;) {
		while (timer-t0<sample_time) { 
			adquire();
		}
		t0+=sample_time;

		for (i=0,p=datap,msk=chmask;i<8;i++){
			if (msk&1) {
				*p++=current_data[i];
				if (p>=DATA_TOP) p-=DATA_LEN;
			}
			msk>>=1;
		}
		datap=p; ndata++;
		if (ndata>maxdata) ndata--;
	}		
}
