;-----------------------------------------
; startup code
;-----------------------------------------
	.area   DIRECT	(ABS,PAG)
; 
; Pseudo regs
;

	.org	32	;Pseudoregistros de TASK 1

ZD0::	.blkb	2
ZD1::	.blkb	2
ZD2::	.blkb	2
ZD3::	.blkb	2
ZD4::	.blkb	2
ZD5::	.blkb	2
ZD6::	.blkb	2
ZD7::	.blkb	2
ZD8::	.blkb	2
ZB0::	.blkb	1
ZB1::	.blkb	1
ZB2::	.blkb	1
ZB3::	.blkb	1
ZB4::	.blkb	1
;
; scratch area
;
ZXT::	.blkb	2

;------------------------------------------------------
;	Reservamos espacio para otras tareas en C
;------------------------------------------------------
		.org 128
;------------------------------------------------------
;----------- Variables de rutinas ISR's ---------------
;------------------------------------------------------


rx_buf_base::	.ds	2
rx_buf_curr::	.ds	2
rx_status::	.ds	1

tx_buf_base::	.ds	2
tx_buf_curr::	.ds	2
tx_count::	.ds	2
tx_status::	.ds	1

;
;----------- Variables de colas ------------------
;

tx_w::		.ds	2	;Puntero escritura cola TX
tx_r::		.ds	2	;Puntero lectura cola TX
rx_w::		.ds	2	;Puntero escritura cola RX
rx_r::		.ds	2	;Puntero lectura cola RX

;
;----------- Variables de TASKER -----------------------
;

tsk_curr::	.ds	1

tsk_table::	

tsk0_sp::	.ds	2	;Puntero de pila de tarea 0
_tsk0_cnt::
tsk0_cnth::	.ds	2	;Consumo de CPU de tarea 0 (ciclos CLK)
tsk0_cntm::	.ds	2
tsk0_cntl::	.ds	2

tsk1_sp::	.ds	2	;Puntero de pila de tarea 1
_tsk1_cnt::
tsk1_cnth::	.ds	2	;Consumo de CPU de tarea 1 (ciclos CLK)
tsk1_cntm::	.ds	2
tsk1_cntl::	.ds	2

tsk2_sp::	.ds	2	;Puntero de pila de tarea 2
_tsk2_cnt::
tsk2_cnth::	.ds	2	;Consumo de CPU de tarea 2 (ciclos CLK)
tsk2_cntm::	.ds	2
tsk2_cntl::	.ds	2

tsk3_sp::	.ds	2	;Puntero de pila de tarea 3
_tsk3_cnt::
tsk3_cnth::	.ds	2	;Consumo de CPU de tarea 3 (ciclos CLK)
tsk3_cntm::	.ds	2
tsk3_cntl::	.ds	2

clocks::	.ds	2	;Variable auxiliar para computo de tiempo

;
; Variable de temporizacin
;

_timer::
timer::		.ds	2

;
; Variables para estadsticas
;

_n_slip::	.ds	2
_n_ip::		.ds	2
_n_icmp::	.ds	2
_n_udp::	.ds	2

_n_tx_icmp::	.ds	2
_n_tx_udp::	.ds	2

;
; Variables de Captura de datos
;

_ndata::	.ds	2	;N de muestras en el buffer
_maxdata::	.ds	2	;N mximo de muestras en el buffer
_nchannels::	.ds	2	;N de canales en cada muestra
_datap::	.ds	2	;Puntero al siguiente dato

_current_data::	.ds	8	;Copia de los 8 canales de entrada

;
;	Zona libre
;

_FREE_0PAGE::

;-----------------------------------------------------------------------
;				startup area
;-----------------------------------------------------------------------

	.area   _CODE (REL)
;
;	setup stack
;
_startup::
	lds     #stack_begin	; initialize stack pointer
	ldaa    #0x10           ; Habilitamos STOP y XIRQ
	tap

;
;	init things
;

	jsr	init_rti
	jsr	init_timer
	jsr	init_tsk
	jsr	init_mem
	jsr	init_queues
	jsr	init_sci
	cli			; Listos para Interrupciones

	jsr	_main_AD	; TAREA 0
_exit::				; En el caso de que la tarea 0 retorne
exit::				; Paramos el reloj
poweroff:			; EJECUTAMOS STOP 
	stop
	bra poweroff

nullirq:
	rti

;***************************************************************
;-----------------------------------------
; end startup code
;-----------------------------------------
;********************************************************************
	.area VECTORS (ABS)
	.org 0xffd6
vectors:
_V_SCII::	.dw sci_isr	; SCII	Asyncronous Serial Interrupt
_V_SPII::	.dw nullirq	; SPII	Syncronous Interrupt
_V_PAII::	.dw nullirq	; PAII	PAI Interrupt
_V_PAOVI::	.dw nullirq	; PAOVI	Pulse Accumulator OVerflow Interrupt
_V_TOI::	.dw nullirq	; TOI	Timer Overfolw Interrupt
_V_OC5I::	.dw nullirq	; OC5I	Output Compare X Interrupt
_V_OC4I::	.dw nullirq	; OC4I
_V_OC3I::	.dw nullirq	; OC3I
_V_OC2I::	.dw timer_isr	; OC2I	(temporizador 10 ms)
_V_OC1I::	.dw nullirq	; OC1I
_V_IC3I::	.dw nullirq	; IC3I	Input Capture X Interrupt
_V_IC2I::	.dw nullirq	; IC2I
_V_IC1I::	.dw nullirq	; IC1I
_V_RTI::	.dw rti_isr	; RTI	Real Timer Interrupt
_V_IRQ::	.dw nullirq	; IRQ	IRQ Interrupt
_V_XIRQ::	.dw poweroff	; XIRQ	XIRQ (non maskable) Interrupt
_V_SWI::	.dw swi_isr	; SWI	SoftWare Interrupt
_V_ILEG::	.dw nullirq	; ILLEGAL	Illegal Opcode Interrupt
_V_COPR::	.dw _startup	; COP Reset
_V_CMR::	.dw _startup	; Clock Monitor Reset
_V_RESET::	.dw _startup	; Reset
;------------------------------------------------------------
	.globl stack_begin
	stack_begin=vectors-1
