
;****************************************************************************
;Zona de cdigo
;****************************************************************************

	.area	_CODE	(REL)

;***************************************************************************
;***************  Rutinas de manejo de FIFOS de punteros *******************
;***************************************************************************

;INIT_QUEUES: Pone los punteros de colas en su valor inicial

init_queues::
	ldx	#tx_q
	stx	*tx_w
	stx	*tx_r
	ldx	#rx_q
	stx	*rx_w
	stx	*rx_r
	rts

;PUT_TX_Q: Aade X a la cola de Transmisin. 
; X -> tx_w
; tx_w+=2
; if (tx_w==tx_top) tx_w=tx_q
; if (tx_w==tx_r) tx_w=tx_w.orig; ZF=1;

put_tx_q::	;Destruye	-
		;Retorna	- (ZF=1 si cola llena)
	psha
	pshb
	pshx
	ldd	*tx_w
	xgdx
	std	,x	; X->tx_w
	inx
	inx		; X+=2
	cpx	#tx_top	; if (tx_w==tx_top) tx_w=tx_q
	bne	ptq1
	ldx	#tx_q
ptq1:	cpx	*tx_r	; if (tx_w==tx_r) tx_w=tx_w.orig; ZF=1;
	beq	ptq2
	stx	*tx_w	; Actualizamos tx_w, ZF=0, ya que tx_w!=NULL	
ptq2:	pulx
	pulb
	pula
	rts

; GET_TX_Q: Extrae puntero de cola de transmisin.
; if (tx_r==tx_w) ZF=1 ; rts
; tx_r->X
; tx_r+=2
; if (tx_r==tx_top) tx_r=tx_q

get_tx_q::	;Destruye	-
		;Retorna	X=Puntero desde la cola
	psha
	pshb
	ldx	*tx_r
	cpx	*tx_w
	beq	gtq1	; if (tx_r==tx_w) ZF=1 ; rts
	ldd	,x
	inx
	inx		; tx_r+=2
	cpx	#tx_top	; if (tx_r==tx_top) tx_r=tx_q
	bne	gtq2
	ldx	#tx_q
gtq2:	stx	*tx_r	; Actualiza tx_r, ZF=0, ya que tx_r!=NULL
	xgdx
gtq1:	pulb
	pula
	rts

;PUT_RX_Q: Aade X a la cola de Recepcin. 
; X -> rx_w
; rx_w+=2
; if (rx_w==rx_top) rx_w=rx_q
; if (rx_w==rx_r) rx_w=rx_w.orig; ZF=1;

put_rx_q::	;Destruye	-
		;Retorna	- (ZF=1 si cola llena)
	psha
	pshb
	pshx
	ldd	*rx_w
	xgdx
	std	,x	; X->rx_w
	inx
	inx		; X+=2
	cpx	#rx_top	; if (rx_w==rx_top) rx_w=rx_q
	bne	prq1
	ldx	#rx_q
prq1:	cpx	*rx_r	; if (rx_w==rx_r) rx_w=rx_w.orig; ZF=1;
	beq	prq2
	stx	*rx_w	; Actualizamos rx_w, ZF=0, ya que rx_w!=NULL	
prq2:	pulx
	pulb
	pula
	rts

; GET_RX_Q: Extrae puntero de cola de recepcin.
; if (rx_r==rx_w) ZF=1 ; rts
; rx_r->X
; rx_r+=2
; if (rx_r==rx_top) rx_r=rx_q

get_rx_q::	;Destruye	-
		;Retorna	X=Puntero desde la cola
	psha
	pshb
	ldx	*rx_r
	cpx	*rx_w
	beq	grq1	; if (rx_r==rx_w) ZF=1 ; rts
	ldd	,x
	inx
	inx		; rx_r+=2
	cpx	#rx_top	; if (rx_r==rx_top) rx_r=rx_q
	bne	grq2
	ldx	#rx_q
grq2:	stx	*rx_r	; Actualiza rx_r, ZF=0, ya que rx_r!=NULL
	xgdx
grq1:	pulb
	pula
	rts


;==========================================================================
;Interface C
;==========================================================================
_put_tx_q::
	psha
	pshb
	pshx
	ldx	*ZD0
	ldd	#0
	jsr	put_tx_q
	beq	_ptqs1
	ldd	#0xffff
_ptqs1:	std	*ZD0
	pulx
	pulb
	pula
	rts

_get_rx_q::
	pshx
	bsr	get_rx_q
	bne	_grqs1
	ldx	#0
_grqs1:	stx	*ZD0
	pulx
	rts
